/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.comm.clients;

import com.google.inject.servlet.SessionScoped;
import java.io.InputStream;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.core.MultivaluedMap;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.common.comm.clients.EurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.ReplacementPathAndClient;
import org.eurekaclinical.common.comm.clients.Router;

@SessionScoped
public class ProxyingClient {
    private final Router config;

    @Inject
    public ProxyingClient(Router inConfig) {
        this.config = inConfig;
    }

    public URI proxyPostMultipart(String path, InputStream inInputStream, MultivaluedMap<String, String> headers) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        return client.doPostCreateMultipart(replacementPath, inInputStream, headers);
    }

    public URI proxyPost(String path, InputStream inputStream, MultivaluedMap<String, String> headers) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        return client.doPostCreate(replacementPath, inputStream, headers);
    }

    public void proxyDelete(String path, MultivaluedMap<String, String> headers) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        client.doDelete(replacementPath, headers);
    }

    public void proxyPut(String path, InputStream inputStream, MultivaluedMap<String, String> headers) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        client.doPut(replacementPath, inputStream, headers);
    }

    public String proxyGet(String path, MultivaluedMap<String, String> queryParams, MultivaluedMap<String, String> headers) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        if (queryParams == null) {
            return client.doGet(replacementPath, headers);
        }
        return client.doGet(replacementPath, queryParams, headers);
    }
}

