/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.servlet;

import com.google.inject.Injector;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.common.comm.clients.ProxyingClient;

@Singleton
public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Set<String> requestHeadersToExclude = new HashSet<String>();
    private final Injector injector;

    @Inject
    public ProxyServlet(Injector inInjector) {
        this.injector = inInjector;
    }

    public void init() throws ServletException {
    }

    protected void doPut(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ProxyingClient client = (ProxyingClient)this.injector.getInstance(ProxyingClient.class);
        String path = servletRequest.getPathInfo();
        MultivaluedMap<String, String> requestHeaders = this.extractRequestHeaders(servletRequest);
        try {
            client.proxyPut(path, (InputStream)servletRequest.getInputStream(), requestHeaders);
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ProxyingClient client = (ProxyingClient)this.injector.getInstance(ProxyingClient.class);
        String path = servletRequest.getPathInfo();
        MultivaluedMap<String, String> requestHeaders = this.extractRequestHeaders(servletRequest);
        try {
            URI created = client.proxyPost(path, (InputStream)servletRequest.getInputStream(), requestHeaders);
            if (created != null) {
                servletResponse.setStatus(201);
                servletResponse.setHeader("Location", created.toString());
            }
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doDelete(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ProxyingClient client = (ProxyingClient)this.injector.getInstance(ProxyingClient.class);
        String path = servletRequest.getPathInfo();
        MultivaluedMap<String, String> requestHeaders = this.extractRequestHeaders(servletRequest);
        try {
            client.proxyDelete(path, requestHeaders);
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ProxyingClient client = (ProxyingClient)this.injector.getInstance(ProxyingClient.class);
        String path = servletRequest.getPathInfo();
        MultivaluedMap<String, String> requestHeaders = this.extractRequestHeaders(servletRequest);
        try {
            Map parameterMap = servletRequest.getParameterMap();
            String response = client.proxyGet(path, ProxyServlet.toMultivaluedMap(parameterMap), requestHeaders);
            servletResponse.getWriter().write(response);
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    private static MultivaluedMap<String, String> toMultivaluedMap(Map<String, String[]> inQueryParameters) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        for (Map.Entry<String, String[]> parameter : inQueryParameters.entrySet()) {
            String[] values;
            for (String value : values = parameter.getValue()) {
                queryParams.add((Object)parameter.getKey(), (Object)value);
            }
        }
        return queryParams;
    }

    private MultivaluedMap<String, String> extractRequestHeaders(HttpServletRequest servletRequest) {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        Enumeration enm = servletRequest.getHeaderNames();
        while (enm.hasMoreElements()) {
            String headerName = (String)enm.nextElement();
            Enumeration enm2 = servletRequest.getHeaders(headerName);
            while (enm2.hasMoreElements()) {
                String nextValue = (String)enm2.nextElement();
                if (requestHeadersToExclude.contains(headerName.toUpperCase())) continue;
                headers.add((Object)headerName, (Object)nextValue);
            }
        }
        this.addXForwardedForHeader(servletRequest, (MultivaluedMap<String, String>)headers);
        return headers;
    }

    private void addXForwardedForHeader(HttpServletRequest servletRequest, MultivaluedMap<String, String> headers) {
        String forHeaderName = "X-Forwarded-For";
        String forHeader = servletRequest.getRemoteAddr();
        String existingForHeader = servletRequest.getHeader(forHeaderName);
        if (existingForHeader != null) {
            forHeader = existingForHeader + ", " + forHeader;
        }
        headers.add((Object)forHeaderName, (Object)forHeader);
        String protoHeaderName = "X-Forwarded-Proto";
        String protoHeader = servletRequest.getScheme();
        headers.add((Object)protoHeaderName, (Object)protoHeader);
    }

    static {
        for (String header : new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade", "Content-Length", "Cookie"}) {
            requestHeadersToExclude.add(header.toUpperCase());
        }
    }
}

