/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HasAuthenticatedSessionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HasAuthenticatedSessionFilter.class);

    public void init(FilterConfig inFilterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inFilterChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        HttpServletResponse servletResponse = (HttpServletResponse)inResponse;
        String remoteUser = servletRequest.getRemoteUser();
        if (remoteUser != null) {
            HttpSession session = servletRequest.getSession(false);
            if (session != null) {
                inFilterChain.doFilter(inRequest, inResponse);
            } else {
                this.goHome(servletRequest, servletResponse);
            }
        } else {
            servletResponse.sendError(400);
        }
    }

    private void goHome(HttpServletRequest inRequest, HttpServletResponse inResponse) throws IOException {
        inResponse.sendRedirect(inRequest.getContextPath() + "/logout?goHome=true");
    }

    public void destroy() {
    }
}

