/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.resource;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eurekaclinical.standardapis.dao.Dao;
import org.eurekaclinical.standardapis.entity.Entity;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

public abstract class AbstractResource<E extends Entity, C> {
    private final Dao<E, Long> dao;
    private final boolean restricted;

    protected AbstractResource(Dao<E, Long> inDao) {
        this(inDao, true);
    }

    protected AbstractResource(Dao<E, Long> inDao, boolean inRestricted) {
        this.dao = inDao;
        this.restricted = inRestricted;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    @GET
    @Produces(value={"application/json"})
    public List<C> getAll(@Context HttpServletRequest req) {
        if (this.restricted && !req.isUserInRole("admin")) {
            throw new HttpStatusException(Response.Status.FORBIDDEN);
        }
        ArrayList<C> results = new ArrayList<C>();
        for (Entity userEntity : this.dao.getAll()) {
            results.add(this.toComm(userEntity, req));
        }
        return results;
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public C getAny(@PathParam(value="id") Long inId, @Context HttpServletRequest req) {
        Entity entity = (Entity)this.dao.retrieve((Object)inId);
        if (entity == null) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        if (this.isAuthorizedEntity(entity, req) && (!this.restricted || req.isUserInRole("admin"))) {
            return this.toComm(entity, req);
        }
        throw new HttpStatusException(Response.Status.NOT_FOUND);
    }

    protected abstract C toComm(E var1, HttpServletRequest var2);

    protected abstract boolean isAuthorizedEntity(E var1, HttpServletRequest var2);
}

