/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.servlet;

import com.google.inject.Injector;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.common.comm.clients.ProxyResponse;
import org.eurekaclinical.common.comm.clients.ProxyingClient;
import org.eurekaclinical.common.comm.clients.ReplacementPathAndClient;

@Singleton
public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Set<String> requestHeadersToExclude = new HashSet<String>();
    private static final Set<String> responseHeadersToExclude;
    private final Injector injector;

    @Inject
    public ProxyServlet(Injector inInjector) {
        this.injector = inInjector;
    }

    public void init() throws ServletException {
    }

    protected void doPut(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ProxyingClient client = (ProxyingClient)this.injector.getInstance(ProxyingClient.class);
        String path = servletRequest.getPathInfo();
        MultivaluedMap<String, String> requestHeaders = ProxyServlet.extractRequestHeaders(servletRequest);
        MultivaluedMap<String, String> parameterMap = ProxyServlet.toMultivaluedMap(servletRequest.getParameterMap());
        try {
            ProxyResponse proxyResponse = client.proxyPut(path, (InputStream)servletRequest.getInputStream(), parameterMap, requestHeaders);
            ClientResponse clientResponse = proxyResponse.getClientResponse();
            servletResponse.setStatus(clientResponse.getStatus());
            ProxyServlet.copyResponseHeaders((MultivaluedMap<String, String>)clientResponse.getHeaders(), proxyResponse.getReplacementPathAndClient(), ProxyServlet.baseUrl(servletRequest.getContextPath(), servletRequest).toString(), servletResponse);
            ProxyServlet.copyStream(clientResponse.getEntityInputStream(), (OutputStream)servletResponse.getOutputStream());
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ProxyingClient client = (ProxyingClient)this.injector.getInstance(ProxyingClient.class);
        String path = servletRequest.getPathInfo();
        MultivaluedMap<String, String> requestHeaders = ProxyServlet.extractRequestHeaders(servletRequest);
        MultivaluedMap<String, String> parameterMap = ProxyServlet.toMultivaluedMap(servletRequest.getParameterMap());
        try {
            ProxyResponse proxyResponse = client.proxyPost(path, (InputStream)servletRequest.getInputStream(), parameterMap, requestHeaders);
            ClientResponse clientResponse = proxyResponse.getClientResponse();
            servletResponse.setStatus(clientResponse.getStatus());
            ProxyServlet.copyResponseHeaders((MultivaluedMap<String, String>)clientResponse.getHeaders(), proxyResponse.getReplacementPathAndClient(), ProxyServlet.baseUrl(servletRequest.getContextPath(), servletRequest).toString(), servletResponse);
            ProxyServlet.copyStream(clientResponse.getEntityInputStream(), (OutputStream)servletResponse.getOutputStream());
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doDelete(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ProxyingClient client = (ProxyingClient)this.injector.getInstance(ProxyingClient.class);
        String path = servletRequest.getPathInfo();
        MultivaluedMap<String, String> requestHeaders = ProxyServlet.extractRequestHeaders(servletRequest);
        MultivaluedMap<String, String> parameterMap = ProxyServlet.toMultivaluedMap(servletRequest.getParameterMap());
        try {
            ProxyResponse proxyResponse = client.proxyDelete(path, parameterMap, requestHeaders);
            ClientResponse clientResponse = proxyResponse.getClientResponse();
            servletResponse.setStatus(clientResponse.getStatus());
            ProxyServlet.copyResponseHeaders((MultivaluedMap<String, String>)clientResponse.getHeaders(), proxyResponse.getReplacementPathAndClient(), ProxyServlet.baseUrl(servletRequest.getContextPath(), servletRequest).toString(), servletResponse);
            ProxyServlet.copyStream(clientResponse.getEntityInputStream(), (OutputStream)servletResponse.getOutputStream());
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        ProxyingClient client = (ProxyingClient)this.injector.getInstance(ProxyingClient.class);
        String path = servletRequest.getPathInfo();
        MultivaluedMap<String, String> requestHeaders = ProxyServlet.extractRequestHeaders(servletRequest);
        MultivaluedMap<String, String> parameterMap = ProxyServlet.toMultivaluedMap(servletRequest.getParameterMap());
        try {
            ProxyResponse proxyResponse = client.proxyGet(path, parameterMap, requestHeaders);
            ClientResponse clientResponse = proxyResponse.getClientResponse();
            servletResponse.setStatus(clientResponse.getStatus());
            ProxyServlet.copyResponseHeaders((MultivaluedMap<String, String>)clientResponse.getHeaders(), proxyResponse.getReplacementPathAndClient(), ProxyServlet.baseUrl(servletRequest.getContextPath(), servletRequest).toString(), servletResponse);
            ProxyServlet.copyStream(clientResponse.getEntityInputStream(), (OutputStream)servletResponse.getOutputStream());
        }
        catch (ClientException e) {
            servletResponse.setStatus(e.getResponseStatus().getStatusCode());
            servletResponse.getOutputStream().print(e.getMessage());
        }
    }

    private static MultivaluedMap<String, String> toMultivaluedMap(Map<String, String[]> inQueryParameters) {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        for (Map.Entry<String, String[]> parameter : inQueryParameters.entrySet()) {
            String[] values;
            for (String value : values = parameter.getValue()) {
                queryParams.add((Object)parameter.getKey(), (Object)value);
            }
        }
        return queryParams;
    }

    private static MultivaluedMap<String, String> extractRequestHeaders(HttpServletRequest servletRequest) {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        Enumeration enm = servletRequest.getHeaderNames();
        while (enm.hasMoreElements()) {
            String headerName = (String)enm.nextElement();
            Enumeration enm2 = servletRequest.getHeaders(headerName);
            while (enm2.hasMoreElements()) {
                String nextValue = (String)enm2.nextElement();
                if (requestHeadersToExclude.contains(headerName.toUpperCase())) continue;
                headers.add((Object)headerName, (Object)nextValue);
            }
        }
        ProxyServlet.addXForwardedForHeader(servletRequest, (MultivaluedMap<String, String>)headers);
        return headers;
    }

    private static void addXForwardedForHeader(HttpServletRequest servletRequest, MultivaluedMap<String, String> headers) {
        String forHeaderName = "X-Forwarded-For";
        String forHeader = servletRequest.getRemoteAddr();
        String existingForHeader = servletRequest.getHeader(forHeaderName);
        if (existingForHeader != null) {
            forHeader = existingForHeader + ", " + forHeader;
        }
        headers.add((Object)forHeaderName, (Object)forHeader);
        String protoHeaderName = "X-Forwarded-Proto";
        String protoHeader = servletRequest.getScheme();
        headers.add((Object)protoHeaderName, (Object)protoHeader);
    }

    private static void copyResponseHeaders(MultivaluedMap<String, String> headers, ReplacementPathAndClient replacementPathAndClient, String proxyResourceUrl, HttpServletResponse response) {
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                for (String val : (List)entry.getValue()) {
                    if (responseHeadersToExclude.contains(key.toUpperCase())) continue;
                    if ("Location".equals(key.toUpperCase())) {
                        response.addHeader(key, replacementPathAndClient.revertPath(proxyResourceUrl));
                    }
                    response.addHeader(key, val);
                }
            }
        }
    }

    private static int copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private static URI baseUrl(String contextPath, HttpServletRequest request) {
        return URI.create(request.getRequestURL().toString()).resolve(contextPath);
    }

    static {
        for (String header : new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade", "Content-Length", "Cookie"}) {
            requestHeadersToExclude.add(header.toUpperCase());
        }
        responseHeadersToExclude = new HashSet<String>();
        for (String header : new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade", "Cookie"}) {
            responseHeadersToExclude.add(header.toUpperCase());
        }
    }
}

