/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.config;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eurekaclinical.common.comm.clients.EurekaClinicalClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionListener
implements HttpSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientSessionListener.class);
    private final Class<? extends EurekaClinicalClient> clientCls;

    public ClientSessionListener(Class<? extends EurekaClinicalClient> inClientCls) {
        this.clientCls = inClientCls;
    }

    public void sessionCreated(HttpSessionEvent hse) {
        LOGGER.info("Creating session for client {} for service {}", (Object)this.clientCls.getName(), (Object)hse.getSession().getServletContext().getContextPath());
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        ServletContext servletContext = hse.getSession().getServletContext();
        LOGGER.info("Destroying session for client {} for service {}", (Object)this.clientCls.getName(), (Object)servletContext.getContextPath());
        Injector injector = (Injector)servletContext.getAttribute(Injector.class.getName());
        try {
            ((EurekaClinicalClient)injector.getInstance(this.clientCls)).close();
        }
        catch (ConfigurationException ce) {
            LOGGER.error("Error destroying session for client " + this.clientCls.getName() + " for service " + servletContext.getContextPath(), (Throwable)ce);
        }
    }
}

