/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.config;

import com.google.inject.Injector;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.comm.clients.AuthorizingEurekaClinicalProxyClient;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolesSessionListener
implements HttpSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolesSessionListener.class);

    public void sessionCreated(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        Injector injector = (Injector)session.getServletContext().getAttribute(Injector.class.getName());
        AuthorizingEurekaClinicalProxyClient client = (AuthorizingEurekaClinicalProxyClient)injector.getInstance(AuthorizingEurekaClinicalProxyClient.class);
        try {
            List<Role> roles = client.getRoles();
            User user = client.getMe();
            List<Long> roleIds = user.getRoles();
            HashSet<String> roleNames = new HashSet<String>();
            for (Role role : roles) {
                if (!roleIds.contains(role.getId())) continue;
                roleNames.add(role.getName());
            }
            session.setAttribute("roles", roleNames);
        }
        catch (ClientException ex) {
            LOGGER.error("Error getting roles", (Throwable)ex);
        }
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        hse.getSession().setAttribute("roles", null);
    }
}

