/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.standardapis.filter.RolesFilter;
import org.eurekaclinical.standardapis.filter.RolesRequestWrapper;

@Singleton
public class RolesFromServiceFilter
implements RolesFilter {
    public void init(FilterConfig fc) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        String username = servletRequest.getRemoteUser();
        if (username != null) {
            HttpSession session = servletRequest.getSession(false);
            assert (session != null) : "session should not be null";
            Principal principal = servletRequest.getUserPrincipal();
            assert (principal != null) : "principal should not be null";
            Set roleNames = (Set)session.getAttribute("roles");
            RolesRequestWrapper wrappedRequest = new RolesRequestWrapper(servletRequest, principal, roleNames);
            inChain.doFilter((ServletRequest)wrappedRequest, inResponse);
        } else {
            inChain.doFilter(inRequest, inResponse);
        }
    }

    public void destroy() {
    }
}

