/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.resource;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.resource.AbstractResource;
import org.eurekaclinical.standardapis.dao.DaoWithUniqueName;
import org.eurekaclinical.standardapis.entity.Entity;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

class GetByNameSupport<E extends Entity, C> {
    private final DaoWithUniqueName<E, Long> dao;
    private final AbstractResource<E, C> resource;

    GetByNameSupport(DaoWithUniqueName<E, Long> inDao, AbstractResource<E, C> inResource) {
        this.dao = inDao;
        this.resource = inResource;
    }

    C get(String inName, HttpServletRequest req) {
        Entity groupEntity = (Entity)this.dao.getByName(inName);
        if (groupEntity == null || !this.resource.isAuthorizedEntity(groupEntity, req) && !req.isUserInRole("admin")) {
            throw new HttpStatusException(Response.Status.NOT_FOUND);
        }
        return this.resource.toComm(groupEntity, req);
    }
}

