/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.comm.clients;

import com.google.inject.servlet.SessionScoped;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eurekaclinical.common.comm.clients.EurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.ReplacementPathAndClient;
import org.eurekaclinical.common.comm.clients.Route;
import org.eurekaclinical.common.comm.clients.RouterTable;
import org.eurekaclinical.common.comm.clients.RouterTableLoadException;

@SessionScoped
public class Router {
    private final Route[] routes;
    private Map<EurekaClinicalClient, Pattern> patterns;

    @Inject
    public Router(RouterTable routesParser) throws RouterTableLoadException {
        this.routes = routesParser.load();
        this.patterns = new HashMap<EurekaClinicalClient, Pattern>();
        for (Route route : this.routes) {
            EurekaClinicalClient client = route.getClient();
            if (!this.patterns.containsKey(client)) continue;
            this.patterns.put(client, Pattern.compile(client.getResourceUrl().toString()));
        }
    }

    public ReplacementPathAndClient getReplacementPathAndClient(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        for (Route route : this.routes) {
            String replacementPath = route.replace(path);
            EurekaClinicalClient client = route.getClient();
            if (replacementPath == null) continue;
            return new ReplacementPathAndClient(replacementPath, client, this.patterns.get(client));
        }
        return null;
    }
}

