/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import com.google.inject.Injector;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.comm.clients.AuthorizingEurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.standardapis.filter.AbstractRolesFilter;

@Singleton
public class RolesFromServiceFilter
extends AbstractRolesFilter {
    private final Injector injector;

    @Inject
    public RolesFromServiceFilter(Injector inInjector) {
        this.injector = inInjector;
    }

    protected String[] getRoles(Principal principal) throws ServletException {
        AuthorizingEurekaClinicalClient client = (AuthorizingEurekaClinicalClient)this.injector.getInstance(AuthorizingEurekaClinicalClient.class);
        try {
            List<Role> roles = client.getRoles();
            User user = client.getMe();
            List<Long> roleIds = user.getRoles();
            ArrayList<String> roleNames = new ArrayList<String>();
            for (Role role : roles) {
                if (!roleIds.contains(role.getId())) continue;
                roleNames.add(role.getName());
            }
            return roleNames.toArray(new String[roleNames.size()]);
        }
        catch (ClientException ex) {
            throw new ServletException((Throwable)ex);
        }
    }
}

