/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.config;

import java.text.MessageFormat;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eurekaclinical.common.comm.clients.EurekaClinicalClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSessionListener
implements HttpSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientSessionListener.class);
    private final Class<? extends EurekaClinicalClient> clientCls;
    private final MessageFormat clientAttributeFormat = new MessageFormat("Key[type={0}, annotation=[none]]");

    public ClientSessionListener(Class<? extends EurekaClinicalClient> inClientCls) {
        if (inClientCls == null) {
            throw new IllegalArgumentException("inClientCls cannot be null");
        }
        this.clientCls = inClientCls;
    }

    public void sessionCreated(HttpSessionEvent hse) {
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        ServletContext servletContext = session.getServletContext();
        String sessionAttr = this.clientAttributeFormat.format(new Object[]{this.clientCls.getName()});
        EurekaClinicalClient client = (EurekaClinicalClient)session.getAttribute(sessionAttr);
        if (client != null) {
            client.close();
            LOGGER.info("Client {} for service {} closed", (Object)this.clientCls.getName(), (Object)servletContext.getContextPath());
        }
    }
}

