/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.comm.clients;

import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.apache.http.cookie.Cookie;
import org.eurekaclinical.common.comm.clients.CasWebResourceWrapper;
import org.eurekaclinical.common.comm.clients.DefaultWebResourceWrapper;
import org.eurekaclinical.common.comm.clients.WebResourceWrapper;
import org.eurekaclinical.common.comm.clients.WebResourceWrapperFactory;

class CasWebResourceWrapperFactory
implements WebResourceWrapperFactory {
    CasWebResourceWrapperFactory() {
    }

    @Override
    public WebResourceWrapper getInstance(ApacheHttpClient4 client, URI resourceUrl) {
        if (this.hasCookieFor(client, resourceUrl)) {
            return new DefaultWebResourceWrapper(client.resource(resourceUrl));
        }
        return new CasWebResourceWrapper(client.resource(resourceUrl));
    }

    private boolean hasCookieFor(ApacheHttpClient4 client, URI resourceUrl) {
        String path = resourceUrl.getPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        List cookies = client.getClientHandler().getCookieStore().getCookies();
        for (Cookie cookie : cookies) {
            if (!"JSESSIONID".equals(cookie.getName()) || !CasWebResourceWrapperFactory.domainMatches(cookie.getDomain(), resourceUrl.getHost()) || !cookie.getPath().equals(path) || cookie.getExpiryDate() != null && !cookie.getExpiryDate().after(new Date())) continue;
            return true;
        }
        return false;
    }

    private static boolean domainMatches(String domain, String host) {
        if ("localhost".equalsIgnoreCase(domain)) {
            return host.equalsIgnoreCase("localhost");
        }
        return HttpCookie.domainMatches(domain, host);
    }
}

