/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.comm.clients;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import com.sun.jersey.multipart.Boundary;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.codehaus.jackson.map.ObjectMapper;
import org.eurekaclinical.common.comm.clients.CasWebResourceWrapperFactory;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.common.comm.clients.WebResourceWrapper;
import org.eurekaclinical.common.comm.clients.WebResourceWrapperFactory;

public abstract class EurekaClinicalClient
implements AutoCloseable {
    private final WebResourceWrapperFactory webResourceWrapperFactory = new CasWebResourceWrapperFactory();
    private final Class<? extends ContextResolver<? extends ObjectMapper>> contextResolverCls;
    private final ApacheHttpClient4 client;
    private final ClientConnectionManager clientConnManager;

    protected EurekaClinicalClient(Class<? extends ContextResolver<? extends ObjectMapper>> cls) {
        this.contextResolverCls = cls;
        DefaultApacheHttpClient4Config clientConfig = new DefaultApacheHttpClient4Config();
        Map properties = clientConfig.getProperties();
        properties.put("com.sun.jersey.impl.client.httpclient.handleCookies", false);
        this.clientConnManager = new ThreadSafeClientConnManager();
        properties.put("com.sun.jersey.impl.client.httpclient.connectionManager", this.clientConnManager);
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        if (this.contextResolverCls != null) {
            clientConfig.getClasses().add(this.contextResolverCls);
        }
        this.client = ApacheHttpClient4.create((ClientConfig)clientConfig);
        this.client.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
    }

    @Override
    public void close() {
        this.client.destroy();
        this.clientConnManager.shutdown();
    }

    protected abstract URI getResourceUrl();

    private WebResourceWrapper getResourceWrapper() {
        return this.webResourceWrapperFactory.getInstance(this.client, this.getResourceUrl());
    }

    protected void doDelete(String path) throws ClientException {
        this.doDelete(path, null);
    }

    protected void doDelete(String path, MultivaluedMap<String, String> headers) throws ClientException {
        ClientResponse response = (ClientResponse)this.getResourceWrapper().rewritten(path, "DELETE").delete(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT, ClientResponse.Status.ACCEPTED);
        response.close();
    }

    protected void doPut(String path) throws ClientException {
        ClientResponse response = (ClientResponse)this.getResourceWrapper().rewritten(path, "PUT").put(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected void doPut(String path, Object o) throws ClientException {
        this.doPut(path, o, null);
    }

    protected void doPut(String path, Object o, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource rewritten = this.getResourceWrapper().rewritten(path, "PUT");
        WebResource.Builder requestBuilder = rewritten.getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(headers, requestBuilder, true, false);
        ClientResponse response = (ClientResponse)requestBuilder.put(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected <T> T doGet(String path, Class<T> cls) throws ClientException {
        return this.doGet(path, cls, null);
    }

    protected <T> T doGet(String path, Class<T> cls, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "GET").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(headers, requestBuilder, false, true);
        ClientResponse response = (ClientResponse)requestBuilder.get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected <T> T doGet(String path, MultivaluedMap<String, String> queryParams, Class<T> cls) throws ClientException {
        return this.doGet(path, queryParams, cls, null);
    }

    protected <T> T doGet(String path, MultivaluedMap<String, String> queryParams, Class<T> cls, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "GET", queryParams).getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(headers, requestBuilder, false, true);
        ClientResponse response = (ClientResponse)requestBuilder.get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected ClientResponse doGetResponse(String path) throws ClientException {
        return this.doGetResponse(path, null);
    }

    protected ClientResponse doGetResponse(String path, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "GET").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(headers, requestBuilder, false, true);
        ClientResponse response = (ClientResponse)requestBuilder.get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return response;
    }

    protected <T> T doGet(String path, GenericType<T> genericType) throws ClientException {
        return this.doGet(path, genericType, null);
    }

    protected <T> T doGet(String path, GenericType<T> genericType, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "GET").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(headers, requestBuilder, false, true);
        ClientResponse response = (ClientResponse)requestBuilder.get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(genericType);
    }

    protected <T> T doGet(String path, MultivaluedMap<String, String> queryParams, GenericType<T> genericType) throws ClientException {
        return this.doGet(path, queryParams, genericType, null);
    }

    protected <T> T doGet(String path, MultivaluedMap<String, String> queryParams, GenericType<T> genericType, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "GET", queryParams).getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(headers, requestBuilder, false, true);
        ClientResponse response = (ClientResponse)requestBuilder.get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(genericType);
    }

    protected <T> T doPost(String path, MultivaluedMap<String, String> formParams, Class<T> cls) throws ClientException {
        return this.doPost(path, formParams, cls, null);
    }

    protected <T> T doPost(String path, MultivaluedMap<String, String> formParams, Class<T> cls, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST").getRequestBuilder();
        EurekaClinicalClient.ensurePostFormHeaders(headers, requestBuilder, true, true);
        ClientResponse response = (ClientResponse)requestBuilder.post(ClientResponse.class, formParams);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(cls);
    }

    protected <T> T doPost(String path, MultivaluedMap<String, String> formParams, GenericType<T> genericType) throws ClientException {
        return this.doPost(path, formParams, genericType, null);
    }

    protected <T> T doPost(String path, MultivaluedMap<String, String> formParams, GenericType<T> genericType, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST").getRequestBuilder();
        EurekaClinicalClient.ensurePostFormHeaders(headers, requestBuilder, true, true);
        ClientResponse response = (ClientResponse)requestBuilder.post(ClientResponse.class, formParams);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (T)response.getEntity(genericType);
    }

    protected void doPost(String path) throws ClientException {
        ClientResponse response = (ClientResponse)this.getResourceWrapper().rewritten(path, "POST").post(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected void doPostForm(String path, MultivaluedMap<String, String> formParams) throws ClientException {
        this.doPostForm(path, formParams, null);
    }

    protected void doPostForm(String path, MultivaluedMap<String, String> formParams, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST").getRequestBuilder();
        EurekaClinicalClient.ensurePostFormHeaders(headers, requestBuilder, true, false);
        ClientResponse response = (ClientResponse)requestBuilder.post(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected void doPost(String path, Object o) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(null, requestBuilder, true, false);
        ClientResponse response = (ClientResponse)requestBuilder.post(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected void doPost(String path, Object o, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(headers, requestBuilder, true, false);
        ClientResponse response = (ClientResponse)requestBuilder.post(ClientResponse.class, o);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    public void doPostMultipart(String path, FormDataMultiPart formDataMultiPart) throws ClientException {
        ClientResponse response = (ClientResponse)this.getResourceWrapper().rewritten(path, "POST").type(Boundary.addBoundary((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE)).post(ClientResponse.class, (Object)formDataMultiPart);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    public void doPostMultipart(String path, FormDataMultiPart formDataMultiPart, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensurePostMultipartHeaders(headers, requestBuilder);
        ClientResponse response = (ClientResponse)requestBuilder.post(ClientResponse.class, (Object)formDataMultiPart);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected void doPostMultipart(String path, InputStream inputStream) throws ClientException {
        this.doPostMultipart(path, inputStream, null);
    }

    protected void doPostMultipart(String path, InputStream inputStream, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensurePostMultipartHeaders(headers, requestBuilder);
        ClientResponse response = (ClientResponse)requestBuilder.post(ClientResponse.class, (Object)inputStream);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.NO_CONTENT);
        response.close();
    }

    protected URI doPostCreate(String path, Object o) throws ClientException {
        return this.doPostCreate(path, o, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI doPostCreate(String path, Object o, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensurePostCreateJsonHeaders(headers, requestBuilder, true, false);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.CREATED);
        try (ClientResponse response = (ClientResponse)requestBuilder.post(ClientResponse.class, o);){
            URI uRI = response.getLocation();
            return uRI;
        }
    }

    protected URI doPostCreateMultipart(String path, InputStream inputStream) throws ClientException {
        return this.doPostCreateMultipart(path, inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI doPostCreateMultipart(String path, InputStream inputStream, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensurePostCreateMultipartHeaders(headers, requestBuilder);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.CREATED);
        try (ClientResponse response = (ClientResponse)requestBuilder.post(ClientResponse.class, (Object)inputStream);){
            URI uRI = response.getLocation();
            return uRI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI doPostCreateMultipart(String path, FormDataMultiPart formDataMultiPart) throws ClientException {
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK, ClientResponse.Status.CREATED);
        try (ClientResponse response = (ClientResponse)((WebResource.Builder)this.getResourceWrapper().rewritten(path, "POST").type(Boundary.addBoundary((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE)).accept(new String[]{"text/plain"})).post(ClientResponse.class, (Object)formDataMultiPart);){
            URI uRI = response.getLocation();
            return uRI;
        }
    }

    protected ClientResponse doPostForProxy(String path, InputStream inputStream, MultivaluedMap<String, String> parameterMap, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "POST", parameterMap).getRequestBuilder();
        EurekaClinicalClient.copyHeaders(headers, requestBuilder);
        return (ClientResponse)requestBuilder.post(ClientResponse.class, (Object)inputStream);
    }

    protected ClientResponse doPutForProxy(String path, InputStream inputStream, MultivaluedMap<String, String> parameterMap, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "PUT", parameterMap).getRequestBuilder();
        EurekaClinicalClient.copyHeaders(headers, requestBuilder);
        return (ClientResponse)requestBuilder.put(ClientResponse.class, (Object)inputStream);
    }

    protected ClientResponse doGetForProxy(String path, MultivaluedMap<String, String> parameterMap, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "GET", parameterMap).getRequestBuilder();
        EurekaClinicalClient.copyHeaders(headers, requestBuilder);
        return (ClientResponse)requestBuilder.get(ClientResponse.class);
    }

    protected ClientResponse doDeleteForProxy(String path, MultivaluedMap<String, String> parameterMap, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "DELETE", parameterMap).getRequestBuilder();
        EurekaClinicalClient.copyHeaders(headers, requestBuilder);
        return (ClientResponse)requestBuilder.delete(ClientResponse.class);
    }

    protected void errorIfStatusEqualTo(ClientResponse response, ClientResponse.Status ... status) throws ClientException {
        this.errorIf(response, status, true);
    }

    protected void errorIfStatusNotEqualTo(ClientResponse response, ClientResponse.Status ... status) throws ClientException {
        this.errorIf(response, status, false);
    }

    protected Long extractId(URI uri) {
        String uriStr = uri.toString();
        return Long.valueOf(uriStr.substring(uriStr.lastIndexOf("/") + 1));
    }

    String doGet(String path, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "GET").getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(headers, requestBuilder, false, true);
        ClientResponse response = (ClientResponse)requestBuilder.get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (String)response.getEntity(String.class);
    }

    String doGet(String path, MultivaluedMap<String, String> queryParams, MultivaluedMap<String, String> headers) throws ClientException {
        WebResource.Builder requestBuilder = this.getResourceWrapper().rewritten(path, "GET", queryParams).getRequestBuilder();
        requestBuilder = EurekaClinicalClient.ensureJsonHeaders(headers, requestBuilder, false, true);
        ClientResponse response = (ClientResponse)requestBuilder.get(ClientResponse.class);
        this.errorIfStatusNotEqualTo(response, ClientResponse.Status.OK);
        return (String)response.getEntity(String.class);
    }

    private void errorIf(ClientResponse response, ClientResponse.Status[] status, boolean bool) throws ClientException {
        ClientResponse.Status clientResponseStatus = response.getClientResponseStatus();
        if (bool) {
            if (EurekaClinicalClient.contains(status, clientResponseStatus)) {
                String message = (String)response.getEntity(String.class);
                throw new ClientException(clientResponseStatus, message);
            }
        } else if (!EurekaClinicalClient.contains(status, clientResponseStatus)) {
            String message = (String)response.getEntity(String.class);
            throw new ClientException(clientResponseStatus, message);
        }
    }

    private static boolean contains(Object[] arr, Object member) {
        for (Object mem : arr) {
            if (!Objects.equals(mem, member)) continue;
            return true;
        }
        return false;
    }

    private static WebResource.Builder ensureJsonHeaders(MultivaluedMap<String, String> headers, WebResource.Builder requestBuilder, boolean contentType, boolean accept) {
        boolean hasContentType = false;
        boolean hasAccept = false;
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                for (String val : (List)entry.getValue()) {
                    if (contentType && "Content-Type".equalsIgnoreCase(key)) {
                        hasContentType = true;
                    } else if (accept && "Accept".equalsIgnoreCase(key)) {
                        hasAccept = true;
                    }
                    requestBuilder = (WebResource.Builder)requestBuilder.header(key, (Object)val);
                }
            }
        }
        if (!hasContentType) {
            requestBuilder = (WebResource.Builder)requestBuilder.type("application/json");
        }
        if (!hasAccept) {
            requestBuilder = (WebResource.Builder)requestBuilder.accept(new String[]{"application/json"});
        }
        return requestBuilder;
    }

    private static WebResource.Builder ensurePostFormHeaders(MultivaluedMap<String, String> headers, WebResource.Builder requestBuilder, boolean contentType, boolean accept) {
        boolean hasContentType = false;
        boolean hasAccept = false;
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                for (String val : (List)entry.getValue()) {
                    if (contentType && "Content-Type".equalsIgnoreCase(key)) {
                        hasContentType = true;
                    } else if (accept && "Accept".equalsIgnoreCase(key)) {
                        hasAccept = true;
                    }
                    requestBuilder = (WebResource.Builder)requestBuilder.header(key, (Object)val);
                }
            }
        }
        if (!hasContentType) {
            requestBuilder = (WebResource.Builder)requestBuilder.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        }
        if (!hasAccept) {
            requestBuilder = (WebResource.Builder)requestBuilder.accept(new String[]{"application/json"});
        }
        return requestBuilder;
    }

    private static WebResource.Builder copyHeaders(MultivaluedMap<String, String> headers, WebResource.Builder requestBuilder) {
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                for (String val : (List)entry.getValue()) {
                    requestBuilder = (WebResource.Builder)requestBuilder.header(key, (Object)val);
                }
            }
        }
        return requestBuilder;
    }

    private static WebResource.Builder ensurePostMultipartHeaders(MultivaluedMap<String, String> headers, WebResource.Builder requestBuilder) {
        boolean hasContentType = false;
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                for (String val : (List)entry.getValue()) {
                    if ("Content-Type".equalsIgnoreCase(key)) {
                        hasContentType = true;
                    }
                    requestBuilder = (WebResource.Builder)requestBuilder.header(key, (Object)val);
                }
            }
        }
        if (!hasContentType) {
            requestBuilder = (WebResource.Builder)requestBuilder.type(Boundary.addBoundary((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        }
        return requestBuilder;
    }

    private static WebResource.Builder ensurePostCreateJsonHeaders(MultivaluedMap<String, String> headers, WebResource.Builder requestBuilder, boolean contentType, boolean accept) {
        boolean hasContentType = false;
        boolean hasAccept = false;
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                for (String val : (List)entry.getValue()) {
                    if (contentType && "Content-Type".equalsIgnoreCase(key)) {
                        hasContentType = true;
                    } else if (accept && "Accept".equalsIgnoreCase(key)) {
                        hasAccept = true;
                    }
                    requestBuilder = (WebResource.Builder)requestBuilder.header(key, (Object)val);
                }
            }
        }
        if (!hasContentType) {
            requestBuilder = (WebResource.Builder)requestBuilder.type("application/json");
        }
        if (!hasAccept) {
            requestBuilder = (WebResource.Builder)requestBuilder.accept(new String[]{"text/plain"});
        }
        return requestBuilder;
    }

    private static WebResource.Builder ensurePostCreateMultipartHeaders(MultivaluedMap<String, String> headers, WebResource.Builder requestBuilder) {
        boolean hasContentType = false;
        boolean hasAccept = false;
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                String key = (String)entry.getKey();
                for (String val : (List)entry.getValue()) {
                    if ("Content-Type".equalsIgnoreCase(key)) {
                        hasContentType = true;
                    } else if ("Accept".equalsIgnoreCase(key)) {
                        hasAccept = true;
                    }
                    requestBuilder = (WebResource.Builder)requestBuilder.header(key, (Object)val);
                }
            }
        }
        if (!hasContentType) {
            requestBuilder = (WebResource.Builder)requestBuilder.type(Boundary.addBoundary((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        }
        if (!hasAccept) {
            requestBuilder = (WebResource.Builder)requestBuilder.accept(new String[]{"text/plain"});
        }
        return requestBuilder;
    }
}

