/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.config;

import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.util.HashMap;
import java.util.Map;
import org.eurekaclinical.common.config.ServletModuleSupport;
import org.eurekaclinical.common.filter.HasAuthenticatedSessionFilter;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;

public abstract class AbstractServletModule
extends ServletModule {
    private static final String UNPROTECTED_PATH = "/*";
    private static final String PROTECTED_PATH = "/protected/*";
    private final ServletModuleSupport servletModuleSupport;

    protected AbstractServletModule(CasEurekaClinicalProperties inProperties) {
        this.servletModuleSupport = new ServletModuleSupport(this.getServletContext().getContextPath(), inProperties);
    }

    protected String getCasProxyCallbackPath() {
        return this.servletModuleSupport.getCasProxyCallbackPath();
    }

    protected String getCasProxyCallbackUrl() {
        return this.servletModuleSupport.getCasProxyCallbackUrl();
    }

    protected abstract Map<String, String> getCasValidationFilterInitParams();

    protected abstract void setupServlets();

    protected void setupFilters() {
        this.filter(this.getProtectedPath(), new String[0]).through(HasAuthenticatedSessionFilter.class);
    }

    protected final void configureServlets() {
        super.configureServlets();
        this.setupCasFilters();
        this.setupFilters();
        this.setupServlets();
    }

    protected String getProtectedPath() {
        return PROTECTED_PATH;
    }

    private void setupCasFilters() {
        this.setupCasSingleSignOutFilter();
        this.setupCasAuthenticationFilter();
        this.setupCasValidationFilter();
        this.setupCasServletRequestWrapperFilter();
        this.setupCasThreadLocalAssertionFilter();
    }

    private void setupCasSingleSignOutFilter() {
        this.bind(SingleSignOutFilter.class).in(Singleton.class);
        this.filter(UNPROTECTED_PATH, new String[0]).through(SingleSignOutFilter.class);
    }

    private void setupCasValidationFilter() {
        this.bind(Cas20ProxyReceivingTicketValidationFilter.class).in(Singleton.class);
        Map<String, String> params = this.getCasValidationFilterInitParams();
        this.filter(this.servletModuleSupport.getCasProxyCallbackPath(), new String[]{this.getProtectedPath()}).through(Cas20ProxyReceivingTicketValidationFilter.class, params);
    }

    private void setupCasAuthenticationFilter() {
        this.bind(AuthenticationFilter.class).in(Singleton.class);
        Map<String, String> params = this.servletModuleSupport.getCasAuthenticationFilterInitParams();
        HashMap<String, String> sessionParams = new HashMap<String, String>(params);
        sessionParams.put("gateway", "true");
        this.filter("/protected/get-session", new String[0]).through(AuthenticationFilter.class, sessionParams);
        this.filterRegex("^/protected/(?!get-session).*", new String[0]).through(AuthenticationFilter.class, params);
    }

    private void setupCasServletRequestWrapperFilter() {
        this.bind(HttpServletRequestWrapperFilter.class).in(Singleton.class);
        Map<String, String> params = this.servletModuleSupport.getServletRequestWrapperFilterInitParams();
        this.filter(UNPROTECTED_PATH, new String[0]).through(HttpServletRequestWrapperFilter.class, params);
    }

    private void setupCasThreadLocalAssertionFilter() {
        this.bind(AssertionThreadLocalFilter.class).in(Singleton.class);
        this.filter(UNPROTECTED_PATH, new String[0]).through(AssertionThreadLocalFilter.class);
    }
}

