/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.comm.clients;

import java.io.InputStream;
import javax.inject.Inject;
import javax.ws.rs.core.MultivaluedMap;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.common.comm.clients.EurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.ProxyResponse;
import org.eurekaclinical.common.comm.clients.ReplacementPathAndClient;
import org.eurekaclinical.common.comm.clients.Router;

public class ProxyingClient {
    private final Router config;

    @Inject
    public ProxyingClient(Router inConfig) {
        this.config = inConfig;
    }

    public ProxyResponse proxyPost(String path, InputStream inputStream, MultivaluedMap<String, String> parameterMap, MultivaluedMap<String, String> headers) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        return new ProxyResponse(client.doPostForProxy(replacementPath, inputStream, parameterMap, headers), replacementPathAndClient);
    }

    public ProxyResponse proxyDelete(String path, MultivaluedMap<String, String> parameterMap, MultivaluedMap<String, String> headers) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        return new ProxyResponse(client.doDeleteForProxy(replacementPath, parameterMap, headers), replacementPathAndClient);
    }

    public ProxyResponse proxyPut(String path, InputStream inputStream, MultivaluedMap<String, String> parameterMap, MultivaluedMap<String, String> headers) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        return new ProxyResponse(client.doPutForProxy(replacementPath, inputStream, parameterMap, headers), replacementPathAndClient);
    }

    public ProxyResponse proxyGet(String path, MultivaluedMap<String, String> parameterMap, MultivaluedMap<String, String> headers) throws ClientException {
        ReplacementPathAndClient replacementPathAndClient = this.config.getReplacementPathAndClient(path);
        EurekaClinicalClient client = replacementPathAndClient.getClient();
        String replacementPath = replacementPathAndClient.getPath();
        return new ProxyResponse(client.doGetForProxy(replacementPath, parameterMap, headers), replacementPathAndClient);
    }
}

