/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.comm.clients;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eurekaclinical.common.comm.clients.EurekaClinicalClient;

public class Route {
    private final EurekaClinicalClient client;
    private final String replacementPathPrefix;
    private final String matchingPathPrefix;
    private final Pattern pattern;

    public Route(String inMatchingPathPrefix, String inReplacementPathPrefix, EurekaClinicalClient inClient) {
        this.matchingPathPrefix = inMatchingPathPrefix;
        this.replacementPathPrefix = inReplacementPathPrefix;
        this.client = inClient;
        this.pattern = Pattern.compile("^" + this.matchingPathPrefix);
    }

    public EurekaClinicalClient getClient() {
        return this.client;
    }

    public String getReplacementPathPrefix() {
        return this.replacementPathPrefix;
    }

    public String replace(String path) {
        Matcher matcher = this.pattern.matcher(path);
        StringBuffer sb = new StringBuffer();
        boolean match = false;
        while (matcher.find()) {
            match = true;
            matcher.appendReplacement(sb, this.replacementPathPrefix);
        }
        matcher.appendTail(sb);
        if (match) {
            return sb.toString();
        }
        return null;
    }
}

