package org.eurekaclinical.common.comm.clients;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*-
 * #%L
 * Eureka! Clinical Common
 * %%
 * Copyright (C) 2016 Emory University
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
/**
 *
 * @author Andrew Post
 */
public class Route {

    private final EurekaClinicalClient client;
    private final String replacementPathPrefix;
    private final String matchingPathPrefix;
    private final Pattern pattern;

    public Route(String inMatchingPathPrefix, String inReplacementPathPrefix, EurekaClinicalClient inClient) {
        this.matchingPathPrefix = inMatchingPathPrefix;
        this.replacementPathPrefix = inReplacementPathPrefix;
        this.client = inClient;
        this.pattern = Pattern.compile("^" + this.matchingPathPrefix);
    }

    public EurekaClinicalClient getClient() {
        return client;
    }

    public String getReplacementPathPrefix() {
        return replacementPathPrefix;
    }

    public String replace(String path) {
        Matcher matcher = this.pattern.matcher(path);
        StringBuffer sb = new StringBuffer();
        boolean match = false;
        while (matcher.find()) {
            match = true;
            matcher.appendReplacement(sb, this.replacementPathPrefix);
        }
        matcher.appendTail(sb);
        if (match) {
            return sb.toString();
        } else {
            return null;
        }
    }

}
