/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eurekaclinical.common.filter.AutoAuthorizationFilter;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.standardapis.dao.UserTemplateDao;
import org.eurekaclinical.standardapis.entity.RoleEntity;
import org.eurekaclinical.standardapis.entity.UserEntity;
import org.eurekaclinical.standardapis.entity.UserTemplateEntity;
import org.jasig.cas.client.authentication.AttributePrincipal;

public abstract class AbstractAutoAuthorizationFilter<R extends RoleEntity, U extends UserEntity<R>, T extends UserTemplateEntity<R>>
implements AutoAuthorizationFilter {
    private final UserTemplateDao<T> userTemplateDao;
    private final UserDao<U> userDao;

    @Inject
    public AbstractAutoAuthorizationFilter(UserTemplateDao<T> inUserTemplateDao, UserDao<U> inUserDao) {
        this.userTemplateDao = inUserTemplateDao;
        this.userDao = inUserDao;
    }

    public void init(FilterConfig fc) throws ServletException {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inFilterChain) throws IOException, ServletException {
        String remoteUser;
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        AttributePrincipal userPrincipal = (AttributePrincipal)servletRequest.getUserPrincipal();
        boolean autoAuthorizationPermitted = true;
        if (autoAuthorizationPermitted && (remoteUser = servletRequest.getRemoteUser()) != null) {
            this.preAuthorizationHook(servletRequest);
            UserTemplateEntity autoAuthorizationTemplate = this.userTemplateDao.getAutoAuthorizationTemplate();
            if (this.userDao.getByName(remoteUser) == null && autoAuthorizationTemplate != null) {
                U user = this.toUserEntity(autoAuthorizationTemplate, remoteUser);
                this.userDao.create(user);
            }
            this.postAuthorizationHook(autoAuthorizationTemplate, servletRequest);
        }
        inFilterChain.doFilter(inRequest, inResponse);
    }

    public void destroy() {
    }

    protected abstract U toUserEntity(T var1, String var2);

    protected void preAuthorizationHook(HttpServletRequest req) {
    }

    protected void postAuthorizationHook(T userTemplate, HttpServletRequest req) {
    }
}

