/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.config;

import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.util.Map;
import org.eurekaclinical.common.config.ServletModuleSupport;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServletModule
extends ServletModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServletModule.class);
    private final String protectedPath;
    private final ServletModuleSupport servletModuleSupport;

    protected AbstractServletModule(CasEurekaClinicalProperties inProperties, String inContainerPath, String inProtectedPath) {
        if (inProtectedPath == null) {
            throw new IllegalArgumentException("inProtectedPath cannot be null");
        }
        this.servletModuleSupport = new ServletModuleSupport(this.getServletContext().getContextPath(), inProperties);
        this.protectedPath = inProtectedPath;
    }

    protected void printParams(Map<String, String> inParams) {
        for (Map.Entry<String, String> entry : inParams.entrySet()) {
            LOGGER.debug(entry.getKey() + " -> " + entry.getValue());
        }
    }

    private void setupCasSingleSignOutFilter() {
        this.bind(SingleSignOutFilter.class).in(Singleton.class);
        this.filter("/*", new String[0]).through(SingleSignOutFilter.class);
    }

    private void setupCasValidationFilter() {
        this.bind(Cas20ProxyReceivingTicketValidationFilter.class).in(Singleton.class);
        Map<String, String> params = this.getCasValidationFilterInitParams();
        this.filter(this.servletModuleSupport.getCasProxyCallbackPath(), new String[]{this.protectedPath}).through(Cas20ProxyReceivingTicketValidationFilter.class, params);
    }

    private void setupCasAuthenticationFilter() {
        this.bind(AuthenticationFilter.class).in(Singleton.class);
        Map<String, String> params = this.servletModuleSupport.getCasAuthenticationFilterInitParams();
        this.filter(this.protectedPath, new String[0]).through(AuthenticationFilter.class, params);
    }

    private void setupCasServletRequestWrapperFilter() {
        this.bind(HttpServletRequestWrapperFilter.class).in(Singleton.class);
        Map<String, String> params = this.servletModuleSupport.getServletRequestWrapperFilterInitParams();
        this.filter("/*", new String[0]).through(HttpServletRequestWrapperFilter.class, params);
    }

    private void setupCasThreadLocalAssertionFilter() {
        this.bind(AssertionThreadLocalFilter.class).in(Singleton.class);
        this.filter("/*", new String[0]).through(AssertionThreadLocalFilter.class);
    }

    protected String getCasProxyCallbackPath() {
        return this.servletModuleSupport.getCasProxyCallbackPath();
    }

    protected String getCasProxyCallbackUrl() {
        return this.servletModuleSupport.getCasProxyCallbackUrl();
    }

    protected abstract Map<String, String> getCasValidationFilterInitParams();

    protected abstract void setupServlets();

    protected void setupFilters() {
    }

    protected final void configureServlets() {
        super.configureServlets();
        this.setupCasFilters();
        this.setupFilters();
        this.setupServlets();
    }

    private void setupCasFilters() {
        this.setupCasSingleSignOutFilter();
        this.setupCasAuthenticationFilter();
        this.setupCasValidationFilter();
        this.setupCasServletRequestWrapperFilter();
        this.setupCasThreadLocalAssertionFilter();
    }
}

