/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import com.google.inject.Injector;
import com.sun.jersey.api.client.ClientResponse;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eurekaclinical.common.comm.Role;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.comm.clients.AuthorizingEurekaClinicalClient;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.standardapis.filter.AbstractRolesFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RolesFromServiceFilter
extends AbstractRolesFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolesFromServiceFilter.class);
    private final Injector injector;
    private String protectedPath;

    @Inject
    public RolesFromServiceFilter(Injector inInjector) {
        this.injector = inInjector;
    }

    public void init(FilterConfig fc) {
        this.protectedPath = fc.getInitParameter("protectedPath");
    }

    protected String[] getRoles(Principal inPrincipal, ServletRequest inRequest) throws ServletException {
        AuthorizingEurekaClinicalClient client = (AuthorizingEurekaClinicalClient)this.injector.getInstance(AuthorizingEurekaClinicalClient.class);
        try {
            List<Role> roles = client.getRoles();
            User user = client.getMe();
            List<Long> roleIds = user.getRoles();
            ArrayList<String> roleNames = new ArrayList<String>();
            for (Role role : roles) {
                if (!roleIds.contains(role.getId())) continue;
                roleNames.add(role.getName());
            }
            return roleNames.toArray(new String[roleNames.size()]);
        }
        catch (ClientException ex) {
            ClientResponse.Status responseStatus = ex.getResponseStatus();
            if (responseStatus.getStatusCode() >= 500 || this.protectedPath == null || ((HttpServletRequest)inRequest).getServletPath().startsWith(this.protectedPath)) {
                throw new ServletException("The user's role information is not available", (Throwable)ex);
            }
            LOGGER.debug("The user's role information is not available", (Throwable)ex);
            return null;
        }
    }
}

