/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.common.filter.AutoAuthCriteriaParser;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.standardapis.dao.UserTemplateDao;
import org.eurekaclinical.standardapis.entity.RoleEntity;
import org.eurekaclinical.standardapis.entity.UserEntity;
import org.eurekaclinical.standardapis.entity.UserTemplateEntity;
import org.jasig.cas.client.authentication.AttributePrincipal;

public abstract class AbstractAutoAuthorizationFilter<R extends RoleEntity, U extends UserEntity<R>, T extends UserTemplateEntity<R>>
implements Filter {
    private final UserTemplateDao<T> userTemplateDao;
    private final UserDao<U> userDao;
    private final AutoAuthCriteriaParser AUTO_AUTH_CRITERIA_PARSER = new AutoAuthCriteriaParser();

    @Inject
    public AbstractAutoAuthorizationFilter(UserTemplateDao<T> inUserTemplateDao, UserDao<U> inUserDao) {
        this.userTemplateDao = inUserTemplateDao;
        this.userDao = inUserDao;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        AttributePrincipal userPrincipal = (AttributePrincipal)servletRequest.getUserPrincipal();
        HttpSession session = servletRequest.getSession(false);
        if (userPrincipal != null && session != null) {
            Map attributes = userPrincipal.getAttributes();
            HttpSession httpSession = session;
            synchronized (httpSession) {
                String[] roleNames = (String[])session.getAttribute("roles");
                if (roleNames == null) {
                    String remoteUser = servletRequest.getRemoteUser();
                    UserTemplateEntity autoAuthorizationTemplate = this.userTemplateDao.getAutoAuthorizationTemplate();
                    try {
                        if (remoteUser != null && autoAuthorizationTemplate != null && this.AUTO_AUTH_CRITERIA_PARSER.parse(autoAuthorizationTemplate.getCriteria(), attributes)) {
                            U user = this.toUserEntity(autoAuthorizationTemplate, remoteUser);
                            this.userDao.create(user);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    chain.doFilter(request, response);
                }
            }
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    protected abstract U toUserEntity(T var1, String var2);
}

