/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.config;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sun.jersey.api.container.filter.RolesAllowedResourceFilterFactory;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.HashMap;
import java.util.Map;
import org.eurekaclinical.common.config.ServletModuleSupport;
import org.eurekaclinical.common.filter.HasAuthenticatedSessionFilter;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.eurekaclinical.standardapis.props.CasJerseyEurekaClinicalProperties;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.util.AssertionThreadLocalFilter;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJerseyServletModule
extends JerseyServletModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJerseyServletModule.class);
    private static final String UNPROTECTED_PATH = "/*";
    private static final String UNPROTECTED_API_PATH = "/api/*";
    private static final String PROTECTED_API_PATH = "/api/protected/*";
    private static final String TEMPLATES_PATH = "/WEB-INF/templates";
    private static final String WEB_CONTENT_REGEX = "(/(image|js|css)/?.*)|(/.*\\.jsp)|(/WEB-INF/.*\\.jsp)|(/WEB-INF/.*\\.jspf)|(/.*\\.html)|(/favicon\\.ico)|(/robots\\.txt)";
    private final String packageNames;
    private final ServletModuleSupport servletModuleSupport;
    private final CasJerseyEurekaClinicalProperties properties;
    @Inject(optional=true)
    private final boolean doesProxy;

    protected AbstractJerseyServletModule(CasJerseyEurekaClinicalProperties inProperties, String inPackageNames, boolean inDoesProxy) {
        this.servletModuleSupport = new ServletModuleSupport(this.getServletContext().getContextPath(), (CasEurekaClinicalProperties)inProperties);
        this.packageNames = inPackageNames;
        this.properties = inProperties;
        this.doesProxy = inDoesProxy;
    }

    protected void printParams(Map<String, String> inParams) {
        for (Map.Entry<String, String> entry : inParams.entrySet()) {
            LOGGER.debug(entry.getKey() + " -> " + entry.getValue());
        }
    }

    protected String getCasProxyCallbackPath() {
        return this.servletModuleSupport.getCasProxyCallbackPath();
    }

    protected String getCasProxyCallbackUrl() {
        return this.servletModuleSupport.getCasProxyCallbackUrl();
    }

    protected Map<String, String> getCasValidationFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("casServerUrlPrefix", this.properties.getCasUrl());
        params.put("serverName", this.properties.getProxyCallbackServer());
        params.put("redirectAfterValidation", "false");
        params.put("acceptAnyProxy", "true");
        if (this.doesProxy) {
            params.put("proxyCallbackUrl", this.getCasProxyCallbackUrl());
            params.put("proxyReceptorUrl", this.getCasProxyCallbackPath());
        }
        return params;
    }

    private void setupCasValidationFilter() {
        this.bind(Cas20ProxyReceivingTicketValidationFilter.class).in(Singleton.class);
        Map<String, String> params = this.getCasValidationFilterInitParams();
        this.filter(this.servletModuleSupport.getCasProxyCallbackPath(), new String[]{PROTECTED_API_PATH}).through(Cas20ProxyReceivingTicketValidationFilter.class, params);
    }

    private void setupCasAuthenticationFilter() {
        this.bind(AuthenticationFilter.class).in(Singleton.class);
        Map<String, String> params = this.servletModuleSupport.getCasAuthenticationFilterInitParams();
        this.filter(PROTECTED_API_PATH, new String[0]).through(AuthenticationFilter.class, params);
    }

    private void setupCasServletRequestWrapperFilter() {
        this.bind(HttpServletRequestWrapperFilter.class).in(Singleton.class);
        Map<String, String> params = this.servletModuleSupport.getServletRequestWrapperFilterInitParams();
        this.filter(UNPROTECTED_PATH, new String[0]).through(HttpServletRequestWrapperFilter.class, params);
    }

    private void setupCasThreadLocalAssertionFilter() {
        this.bind(AssertionThreadLocalFilter.class).in(Singleton.class);
        this.filter(UNPROTECTED_PATH, new String[0]).through(AssertionThreadLocalFilter.class);
    }

    private void setupContainer() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("com.sun.jersey.api.json.POJOMappingFeature", "true");
        params.put("com.sun.jersey.config.property.packages", this.packageNames);
        params.put("com.sun.jersey.spi.container.ResourceFilters", RolesAllowedResourceFilterFactory.class.getName());
        params.put("com.sun.jersey.config.property.JSPTemplatesBasePath", TEMPLATES_PATH);
        params.put("com.sun.jersey.config.property.WebPageContentRegex", WEB_CONTENT_REGEX);
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        this.serve(UNPROTECTED_API_PATH, new String[0]).with(GuiceContainer.class, params);
    }

    protected void setupFilters() {
        this.filter(PROTECTED_API_PATH, new String[0]).through(HasAuthenticatedSessionFilter.class);
    }

    protected void configureServlets() {
        super.configureServlets();
        this.setupCasFilters();
        this.setupFilters();
        this.setupContainer();
    }

    private void setupCasFilters() {
        this.setupCasValidationFilter();
        this.setupCasAuthenticationFilter();
        this.setupCasServletRequestWrapperFilter();
        this.setupCasThreadLocalAssertionFilter();
    }
}

