/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.config;

import java.util.HashMap;
import java.util.Map;
import org.eurekaclinical.standardapis.props.CasEurekaClinicalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServletModuleSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletModuleSupport.class);
    private static final String CAS_PROXY_CALLBACK_PATH = "/proxyCallback";
    private final CasEurekaClinicalProperties properties;
    private final String contextPath;

    ServletModuleSupport(String contextPath, CasEurekaClinicalProperties inProperties) {
        this.properties = inProperties;
        this.contextPath = contextPath;
    }

    Map<String, String> getCasAuthenticationFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("casServerLoginUrl", this.getCasLoginUrl());
        params.put("serverName", this.properties.getProxyCallbackServer());
        params.put("renew", Boolean.toString(this.properties.getCasLoginRenew()));
        params.put("gateway", Boolean.toString(this.properties.getCasLoginGateway()));
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    Map<String, String> getServletRequestWrapperFilterInitParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roleAttribute", "authorities");
        if (LOGGER.isDebugEnabled()) {
            this.printParams(params);
        }
        return params;
    }

    CasEurekaClinicalProperties getApplicationProperties() {
        return this.properties;
    }

    protected String getCasProxyCallbackUrl() {
        return this.properties.getProxyCallbackServer() + this.contextPath + CAS_PROXY_CALLBACK_PATH;
    }

    protected String getCasProxyCallbackPath() {
        return CAS_PROXY_CALLBACK_PATH;
    }

    private void printParams(Map<String, String> inParams) {
        for (Map.Entry<String, String> entry : inParams.entrySet()) {
            LOGGER.debug(entry.getKey() + " -> " + entry.getValue());
        }
    }

    private String getCasLoginUrl() {
        return this.properties.getCasLoginUrl();
    }
}

