/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.common.filter.AutoAuthCriteriaParser;
import org.eurekaclinical.common.filter.CriteriaParseException;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.standardapis.dao.UserTemplateDao;
import org.eurekaclinical.standardapis.entity.RoleEntity;
import org.eurekaclinical.standardapis.entity.UserEntity;
import org.eurekaclinical.standardapis.entity.UserTemplateEntity;
import org.jasig.cas.client.authentication.AttributePrincipal;

@Singleton
public class AutoAuthorizationFilter
implements Filter {
    private final UserTemplateDao<? extends RoleEntity, ?> userTemplateDao;
    private final AutoAuthCriteriaParser AUTO_AUTH_CRITERIA_PARSER = new AutoAuthCriteriaParser();
    private final UserDao<? extends UserEntity<? extends RoleEntity>> userDao;

    @Inject
    public AutoAuthorizationFilter(UserTemplateDao<? extends RoleEntity, ?> inUserTemplateDao, UserDao<? extends UserEntity<? extends RoleEntity>> inUserDao) {
        this.userTemplateDao = inUserTemplateDao;
        this.userDao = inUserDao;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        AttributePrincipal userPrincipal = (AttributePrincipal)servletRequest.getUserPrincipal();
        HttpSession session = servletRequest.getSession(false);
        if (userPrincipal != null && session != null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                String[] roleNames = (String[])session.getAttribute("roles");
                if (roleNames == null) {
                    this.createUser(servletRequest.getRemoteUser(), userPrincipal.getAttributes());
                    chain.doFilter(request, response);
                }
            }
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private void createUser(String username, Map<String, Object> attributes) {
        UserTemplateEntity autoAuthorizationTemplate = this.userTemplateDao.getAutoAuthorizationTemplate();
        try {
            if (username != null && autoAuthorizationTemplate != null && this.AUTO_AUTH_CRITERIA_PARSER.parse(autoAuthorizationTemplate.getCriteria(), attributes)) {
                this.userDao.createUser(username, autoAuthorizationTemplate.getRoles());
            }
        }
        catch (CriteriaParseException criteriaParseException) {
            // empty catch block
        }
    }
}

