/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.filter;

import java.io.IOException;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@Singleton
public class HasAuthenticatedSessionFilter
implements Filter {
    public void init(FilterConfig inFilterConfig) {
    }

    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inFilterChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        HttpServletResponse servletResponse = (HttpServletResponse)inResponse;
        String remoteUser = servletRequest.getRemoteUser();
        HttpSession session = servletRequest.getSession(false);
        if (remoteUser != null && session != null) {
            inRequest.setAttribute("userIsActivated", (Object)Boolean.TRUE);
            inFilterChain.doFilter(inRequest, inResponse);
        } else {
            servletResponse.sendError(400);
        }
    }

    public void destroy() {
    }
}

