/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.common.auth;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.auth.AbstractUserSupport;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.standardapis.entity.UserEntity;
import org.eurekaclinical.standardapis.exception.HttpStatusException;
import org.jasig.cas.client.authentication.AttributePrincipal;

public final class AuthorizedUserSupport<E extends UserEntity<?>, D extends UserDao<?, E>, U extends User>
extends AbstractUserSupport<E, U> {
    private final D userDao;

    public AuthorizedUserSupport(D inUserDao) {
        this.userDao = inUserDao;
    }

    @Override
    public boolean isSameUser(HttpServletRequest servletRequest, E user) {
        return this.isSameUser(servletRequest, (E)user.getUsername());
    }

    public E getUser(HttpServletRequest servletRequest) {
        AttributePrincipal principal = this.getUserPrincipal(servletRequest);
        UserEntity result = this.userDao.getByPrincipal((Principal)principal);
        if (result == null) {
            throw new HttpStatusException(Response.Status.FORBIDDEN, "User " + principal.getName() + " is not authorized to use this resource");
        }
        return (E)result;
    }
}

