/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.OracleType;

abstract class TypeAccessor
extends Accessor {
    byte[][] pickledBytes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Mar_12_20:10:49_PDT_2013";
    public static final boolean TRACE = false;

    TypeAccessor() {
    }

    abstract OracleType otypeFromName(String var1) throws SQLException;

    @Override
    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2, String string) throws SQLException {
        this.describeTypeName = string;
        this.initForDescribe(n2, n3, bl, n5, n6, n4, n7, n8, s2);
    }

    @Override
    void setOffsets(int n2) {
        if (!this.outBind) {
            this.columnIndex = this.statement.defineByteSubRange;
            this.statement.defineByteSubRange = this.columnIndex + n2 * this.byteLength;
        }
        if (this.pickledBytes == null || this.pickledBytes.length < n2) {
            this.pickledBytes = new byte[n2][];
        }
    }

    byte[] pickledBytes(int n2) {
        return this.pickledBytes[n2];
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 0;
        this.internalTypeName = string;
    }

    @Override
    void initMetadata() throws SQLException {
        if (this.describeOtype == null && this.describeTypeName != null) {
            this.describeOtype = this.otypeFromName(this.describeTypeName);
        }
        if (this.internalOtype == null && this.internalTypeName != null) {
            this.internalOtype = this.otypeFromName(this.internalTypeName);
        }
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            byte[] byArray2 = this.pickledBytes(n2);
            int n3 = byArray2.length;
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    @Override
    long updateChecksum(long l2, int n2) throws SQLException {
        byte[] byArray = this.pickledBytes(n2);
        l2 = byArray == null || byArray.length == 0 ? CRC64.updateChecksum(l2, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length) : CRC64.updateChecksum(l2, byArray, 0, byArray.length);
        return l2;
    }
}

