/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.protempa.client.json;

import java.io.IOException;
import java.util.HashMap;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.protempa.Attribute;
import org.protempa.ExtendedPropositionDefinition;
import org.protempa.GapFunction;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.PropertyDefinition;
import org.protempa.ReferenceDefinition;
import org.protempa.SimpleGapFunction;
import org.protempa.SourceId;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPatternOffset;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.Value;

public final class HighLevelAbstractionJsonDeserializer
extends JsonDeserializer<HighLevelAbstractionDefinition> {
    private JsonParser parser;

    public HighLevelAbstractionDefinition deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        this.parser = jp;
        if (this.parser.getCurrentToken() == JsonToken.START_OBJECT) {
            this.nextToken();
        }
        this.checkField("id");
        HighLevelAbstractionDefinition value = new HighLevelAbstractionDefinition((String)this.parser.readValueAs(String.class));
        value.setInDataSource(false);
        value.setSolid(true);
        value.setConcatenable(true);
        value.setGapFunction((GapFunction)new SimpleGapFunction());
        this.nextToken();
        this.checkField("displayName");
        value.setDisplayName((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("abbreviatedDisplayName");
        value.setAbbreviatedDisplayName((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("description");
        value.setDescription((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("inverseIsA");
        value.setInverseIsA((String[])this.parser.readValueAs(String[].class));
        this.nextToken();
        this.checkField("properties");
        value.setPropertyDefinitions((PropertyDefinition[])this.parser.readValueAs(PropertyDefinition[].class));
        this.nextToken();
        this.checkField("references");
        value.setReferenceDefinitions((ReferenceDefinition[])this.parser.readValueAs(ReferenceDefinition[].class));
        this.nextToken();
        this.checkField("solid");
        value.setSolid(this.parser.getBooleanValue());
        this.nextToken();
        this.checkField("concatenable");
        value.setConcatenable(this.parser.getBooleanValue());
        this.nextToken();
        this.checkField("inDataSource");
        value.setInDataSource(this.parser.getBooleanValue());
        this.nextToken();
        this.checkField("sourceId");
        SourceId sourceId = (SourceId)this.parser.readValueAs(SourceId.class);
        value.setSourceId(sourceId);
        this.nextToken();
        this.checkField("gapFunction");
        value.setGapFunction((GapFunction)this.parser.readValueAs(GapFunction.class));
        this.nextToken();
        this.checkField("extendedPropositions");
        this.nextToken();
        int i = 1;
        HashMap<Long, TemporalExtendedPropositionDefinition> indices = new HashMap<Long, TemporalExtendedPropositionDefinition>();
        while (this.parser.getCurrentToken() != JsonToken.END_OBJECT) {
            this.checkField("" + i);
            TemporalExtendedPropositionDefinition ep = (TemporalExtendedPropositionDefinition)this.parser.readValueAs(TemporalExtendedPropositionDefinition.class);
            value.add((ExtendedPropositionDefinition)ep);
            indices.put(Long.valueOf(i), ep);
            this.nextToken();
            ++i;
        }
        this.nextToken();
        this.checkField("relations");
        this.nextToken();
        while (this.parser.getCurrentToken() != JsonToken.END_OBJECT) {
            this.checkField("lhs");
            ExtendedPropositionDefinition lhs = (ExtendedPropositionDefinition)indices.get(this.parser.getLongValue());
            if (!(lhs instanceof TemporalExtendedPropositionDefinition)) {
                throw new JsonMappingException("Proposition definition " + lhs.getPropositionId() + " is not temporal and cannot be in a temporal relation");
            }
            this.nextToken();
            this.checkField("rhs");
            ExtendedPropositionDefinition rhs = (ExtendedPropositionDefinition)indices.get(this.parser.getLongValue());
            if (!(rhs instanceof TemporalExtendedPropositionDefinition)) {
                throw new JsonMappingException("Proposition definition " + rhs.getPropositionId() + " is not temporal and cannot be in a temporal relation");
            }
            this.nextToken();
            this.checkField("relation");
            Relation rel = (Relation)this.parser.readValueAs(Relation.class);
            value.setRelation((TemporalExtendedPropositionDefinition)lhs, (TemporalExtendedPropositionDefinition)rhs, rel);
            this.nextToken();
        }
        this.nextToken();
        this.checkField("temporalOffset");
        this.nextToken();
        if (this.parser.getCurrentToken() != JsonToken.END_OBJECT) {
            TemporalPatternOffset offsets = new TemporalPatternOffset();
            this.checkField("startExtendedProposition");
            if (this.parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                offsets.setStartTemporalExtendedPropositionDefinition(null);
            } else {
                Long startIndex = this.parser.getLongValue();
                if (startIndex != null) {
                    ExtendedPropositionDefinition start = (ExtendedPropositionDefinition)indices.get(startIndex);
                    if (!(start instanceof TemporalExtendedPropositionDefinition)) {
                        throw new JsonMappingException("Proposition definition " + start.getPropositionId() + " is not temporal and cannot be in a temporal relation");
                    }
                    offsets.setStartTemporalExtendedPropositionDefinition((TemporalExtendedPropositionDefinition)start);
                }
            }
            this.nextToken();
            this.checkField("startValue");
            offsets.setStartAbstractParamValue((Value)this.parser.readValueAs(Value.class));
            this.nextToken();
            this.checkField("startSide");
            offsets.setStartIntervalSide((Interval.Side)this.parser.readValueAs(Interval.Side.class));
            this.nextToken();
            this.checkField("startOffset");
            offsets.setStartOffset(this.parser.getIntValue());
            this.nextToken();
            this.checkField("startOffsetUnits");
            offsets.setStartOffsetUnits((Unit)this.parser.readValueAs(Unit.class));
            this.nextToken();
            this.checkField("finishExtendedProposition");
            if (this.parser.getCurrentToken() == JsonToken.VALUE_NULL) {
                offsets.setFinishTemporalExtendedPropositionDefinition(null);
            } else {
                Long finishIndex = this.parser.getLongValue();
                if (finishIndex != null) {
                    ExtendedPropositionDefinition finish = (ExtendedPropositionDefinition)indices.get(finishIndex);
                    if (!(finish instanceof TemporalExtendedPropositionDefinition)) {
                        throw new JsonMappingException("Proposition definition " + finish.getPropositionId() + " is not temporal and cannot be in a temporal relation");
                    }
                    offsets.setFinishTemporalExtendedPropositionDefinition((TemporalExtendedPropositionDefinition)finish);
                }
            }
            this.nextToken();
            this.checkField("finishValue");
            offsets.setFinishAbstractParamValue((Value)this.parser.readValueAs(Value.class));
            this.nextToken();
            this.checkField("finishSide");
            offsets.setFinishIntervalSide((Interval.Side)this.parser.readValueAs(Interval.Side.class));
            this.nextToken();
            this.checkField("finishOffset");
            offsets.setFinishOffset(this.parser.getIntValue());
            this.nextToken();
            this.checkField("finishOffsetUnits");
            offsets.setFinishOffsetUnits((Unit)this.parser.readValueAs(Unit.class));
            this.nextToken();
            value.setTemporalOffset(offsets);
        }
        this.nextToken();
        this.checkField("attributes");
        value.setAttributes((Attribute[])this.parser.readValueAs(Attribute[].class));
        this.nextToken();
        return value;
    }

    private void checkField(String field) throws JsonParseException, IOException {
        if (this.parser.getCurrentToken() != JsonToken.FIELD_NAME || !field.equals(this.parser.getCurrentName())) {
            this.fail(field);
        } else {
            this.nextValue();
        }
    }

    private void nextToken() throws JsonParseException, IOException {
        this.parser.nextToken();
    }

    private void nextValue() throws JsonParseException, IOException {
        this.parser.nextValue();
    }

    private void fail(String property) throws JsonProcessingException {
        throw new JsonParseException(property + " not found in expected location", this.parser.getCurrentLocation());
    }
}

