/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.protempa.client.json;

import java.io.IOException;
import java.util.Set;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.protempa.Attribute;
import org.protempa.GapFunction;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.LowLevelAbstractionValueDefinition;
import org.protempa.PropertyDefinition;
import org.protempa.ReferenceDefinition;
import org.protempa.SlidingWindowWidthMode;
import org.protempa.SourceId;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueType;

public final class LowLevelAbstractionJsonDeserializer
extends JsonDeserializer<LowLevelAbstractionDefinition> {
    private JsonParser parser;

    public LowLevelAbstractionDefinition deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        this.parser = jp;
        if (this.parser.getCurrentToken() == JsonToken.START_OBJECT) {
            this.nextToken();
        }
        this.checkField("id");
        LowLevelAbstractionDefinition value = new LowLevelAbstractionDefinition((String)this.parser.readValueAs(String.class));
        value.setInDataSource(false);
        this.nextToken();
        this.checkField("displayName");
        value.setDisplayName((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("abbreviatedDisplayName");
        value.setAbbreviatedDisplayName((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("description");
        value.setDescription((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("algorithm");
        value.setAlgorithmId((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("inverseIsA");
        value.setInverseIsA((String[])this.parser.readValueAs(String[].class));
        this.nextToken();
        this.checkField("abstractedFrom");
        Set abstractedFrom = (Set)this.parser.readValueAs(Set.class);
        for (String af : abstractedFrom) {
            value.addPrimitiveParameterId(af);
        }
        this.nextToken();
        this.checkField("properties");
        value.setPropertyDefinitions((PropertyDefinition[])this.parser.readValueAs(PropertyDefinition[].class));
        this.nextToken();
        this.checkField("references");
        value.setReferenceDefinitions((ReferenceDefinition[])this.parser.readValueAs(ReferenceDefinition[].class));
        this.nextToken();
        this.checkField("sourceId");
        SourceId sourceId = (SourceId)this.parser.readValueAs(SourceId.class);
        value.setSourceId(sourceId);
        this.nextToken();
        this.checkField("concatenable");
        value.setConcatenable(this.parser.getBooleanValue());
        this.nextToken();
        this.checkField("inDataSource");
        value.setInDataSource(this.parser.getBooleanValue());
        this.nextToken();
        this.checkField("gapFunction");
        value.setGapFunction((GapFunction)this.parser.readValueAs(GapFunction.class));
        this.nextToken();
        this.checkField("minimumDuration");
        if (this.parser.getCurrentToken() != JsonToken.VALUE_NULL) {
            value.setMinimumDuration(Integer.valueOf(this.parser.getIntValue()));
        }
        this.nextToken();
        this.checkField("minimumDurationUnits");
        value.setMinimumDurationUnits((Unit)this.parser.readValueAs(Unit.class));
        this.nextToken();
        this.checkField("maximumDuration");
        if (this.parser.getCurrentToken() != JsonToken.VALUE_NULL) {
            value.setMaximumDuration(Integer.valueOf(this.parser.getIntValue()));
        }
        this.nextToken();
        this.checkField("maximumDurationUnits");
        value.setMaximumDurationUnits((Unit)this.parser.readValueAs(Unit.class));
        this.nextToken();
        this.checkField("valueType");
        value.setValueType((ValueType)this.parser.readValueAs(ValueType.class));
        this.nextToken();
        this.checkField("skipStart");
        value.setSkipStart(this.parser.getIntValue());
        this.nextToken();
        this.checkField("skipEnd");
        value.setSkipEnd(this.parser.getIntValue());
        this.nextToken();
        this.checkField("skip");
        value.setSkip(this.parser.getIntValue());
        this.nextToken();
        this.checkField("maxOverlapping");
        value.setMaxOverlapping(this.parser.getIntValue());
        this.nextToken();
        this.checkField("slidingWindowWidthMode");
        value.setSlidingWindowWidthMode((SlidingWindowWidthMode)this.parser.readValueAs(SlidingWindowWidthMode.class));
        this.nextToken();
        this.checkField("maximumNumberOfValues");
        value.setMaximumNumberOfValues(this.parser.getIntValue());
        this.nextToken();
        this.checkField("minimumNumberOfValues");
        value.setMinimumNumberOfValues(this.parser.getIntValue());
        this.nextToken();
        this.checkField("minGapBetweenValues");
        value.setMinimumGapBetweenValues(Integer.valueOf(this.parser.getIntValue()));
        this.nextToken();
        this.checkField("minGapBetweenValuesUnits");
        value.setMinimumGapBetweenValuesUnits((Unit)this.parser.readValueAs(Unit.class));
        this.nextToken();
        this.checkField("maxGapBetweenValues");
        if (this.parser.getCurrentToken() != JsonToken.VALUE_NULL) {
            value.setMaximumGapBetweenValues(Integer.valueOf(this.parser.getIntValue()));
        }
        this.nextToken();
        this.checkField("maxGapBetweenValuesUnits");
        value.setMaximumGapBetweenValuesUnits((Unit)this.parser.readValueAs(Unit.class));
        this.nextToken();
        this.checkField("context");
        value.setContextId((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("values");
        this.nextToken();
        while (this.parser.getCurrentToken() != JsonToken.END_OBJECT) {
            this.checkField("id");
            LowLevelAbstractionValueDefinition valDef = new LowLevelAbstractionValueDefinition(value, (String)this.parser.readValueAs(String.class));
            this.nextToken();
            this.checkField("value");
            valDef.setValue((Value)this.parser.readValueAs(Value.class));
            this.nextToken();
            this.checkField("params");
            this.nextToken();
            while (this.parser.getCurrentToken() != JsonToken.END_ARRAY) {
                this.nextToken();
                this.checkField("name");
                String name = (String)this.parser.readValueAs(String.class);
                this.nextToken();
                this.checkField("value");
                Value val = (Value)this.parser.readValueAs(Value.class);
                this.nextToken();
                this.checkField("comp");
                String compStr = (String)this.parser.readValueAs(String.class);
                if (compStr != null && !compStr.isEmpty() && !compStr.equals("null")) {
                    ValueComparator comp = ValueComparator.valueOf((String)compStr);
                    valDef.setParameterValue(name, val);
                    valDef.setParameterComp(name, comp);
                }
                this.nextToken();
                this.nextToken();
            }
            this.nextToken();
        }
        this.nextToken();
        this.checkField("attributes");
        value.setAttributes((Attribute[])this.parser.readValueAs(Attribute[].class));
        this.nextToken();
        return value;
    }

    private void checkField(String field) throws JsonParseException, IOException {
        if (this.parser.getCurrentToken() != JsonToken.FIELD_NAME || !field.equals(this.parser.getCurrentName())) {
            this.fail(field);
        } else {
            this.nextValue();
        }
    }

    private void nextToken() throws JsonParseException, IOException {
        this.parser.nextToken();
    }

    private void nextValue() throws JsonParseException, IOException {
        this.parser.nextValue();
    }

    private void fail(String property) throws JsonProcessingException {
        throw new JsonParseException("\"" + property + "\" not found in expected location. Found \"" + this.parser.getCurrentToken() + "\" instead", this.parser.getCurrentLocation());
    }
}

