/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.protempa.client.json;

import java.io.IOException;
import java.util.HashMap;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.protempa.Attribute;
import org.protempa.PropertyDefinition;
import org.protempa.ReferenceDefinition;
import org.protempa.SliceDefinition;
import org.protempa.SourceId;
import org.protempa.TemporalExtendedPropositionDefinition;

public final class SliceAbstractionJsonDeserializer
extends JsonDeserializer<SliceDefinition> {
    private JsonParser parser;

    public SliceDefinition deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        this.parser = jp;
        if (this.parser.getCurrentToken() == JsonToken.START_OBJECT) {
            this.nextToken();
        }
        this.checkField("id");
        SliceDefinition value = new SliceDefinition((String)this.parser.readValueAs(String.class));
        value.setInDataSource(false);
        this.nextToken();
        this.checkField("displayName");
        value.setDisplayName((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("abbreviatedDisplayName");
        value.setAbbreviatedDisplayName((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("description");
        value.setDescription((String)this.parser.readValueAs(String.class));
        this.nextToken();
        this.checkField("inverseIsA");
        value.setInverseIsA((String[])this.parser.readValueAs(String[].class));
        this.nextToken();
        this.checkField("extendedPropositions");
        this.nextToken();
        int i = 1;
        HashMap<Long, TemporalExtendedPropositionDefinition> indices = new HashMap<Long, TemporalExtendedPropositionDefinition>();
        while (this.parser.getCurrentToken() != JsonToken.END_OBJECT) {
            this.checkField("" + i);
            TemporalExtendedPropositionDefinition lhs = (TemporalExtendedPropositionDefinition)this.parser.readValueAs(TemporalExtendedPropositionDefinition.class);
            value.add(lhs);
            indices.put(Long.valueOf(i), lhs);
            this.nextToken();
            ++i;
        }
        this.nextToken();
        this.checkField("properties");
        value.setPropertyDefinitions((PropertyDefinition[])this.parser.readValueAs(PropertyDefinition[].class));
        this.nextToken();
        this.checkField("references");
        value.setReferenceDefinitions((ReferenceDefinition[])this.parser.readValueAs(ReferenceDefinition[].class));
        this.nextToken();
        this.checkField("inDataSource");
        value.setInDataSource(this.parser.getBooleanValue());
        this.nextToken();
        this.checkField("sourceId");
        SourceId sourceId = (SourceId)this.parser.readValueAs(SourceId.class);
        value.setSourceId(sourceId);
        this.nextToken();
        this.checkField("minIndex");
        value.setMinIndex(this.parser.getIntValue());
        this.nextToken();
        this.checkField("maxIndex");
        value.setMaxIndex(this.parser.getIntValue());
        this.nextToken();
        this.checkField("mergedInterval");
        value.setMergedInterval(this.parser.getBooleanValue());
        this.nextToken();
        this.checkField("attributes");
        value.setAttributes((Attribute[])this.parser.readValueAs(Attribute[].class));
        this.nextToken();
        return value;
    }

    private void checkField(String field) throws JsonParseException, IOException {
        if (this.parser.getCurrentToken() != JsonToken.FIELD_NAME || !field.equals(this.parser.getCurrentName())) {
            this.fail(field);
        } else {
            this.nextValue();
        }
    }

    private void nextToken() throws JsonParseException, IOException {
        this.parser.nextToken();
    }

    private void nextValue() throws JsonParseException, IOException {
        this.parser.nextValue();
    }

    private void fail(String property) throws JsonProcessingException {
        throw new JsonParseException(property + " not found in expected location", this.parser.getCurrentLocation());
    }
}

