/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.registry.service.resource;

import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.eurekaclinical.common.resource.AbstractNamedReadWriteResource;
import org.eurekaclinical.registry.client.comm.Component;
import org.eurekaclinical.registry.service.dao.ComponentDao;
import org.eurekaclinical.registry.service.dao.ComponentTypeDao;
import org.eurekaclinical.registry.service.entity.ComponentEntity;
import org.eurekaclinical.registry.service.entity.ComponentTypeEntity;

@Path(value="/protected/components")
@Transactional
public class ComponentResource
extends AbstractNamedReadWriteResource<ComponentEntity, Component> {
    private final ComponentTypeDao<ComponentTypeEntity> componentTypeDao;
    private final ComponentDao<ComponentEntity> componentDao;

    @Inject
    public ComponentResource(ComponentDao<ComponentEntity> inComponentDao, ComponentTypeDao<ComponentTypeEntity> inComponentTypeDao) {
        super(inComponentDao, false);
        this.componentDao = inComponentDao;
        this.componentTypeDao = inComponentTypeDao;
    }

    @GET
    @Produces(value={"application/json"})
    public List<Component> getAll(@Context HttpServletRequest req) {
        String[] types = req.getParameterValues("type");
        ArrayList<Component> result = new ArrayList<Component>();
        if (types != null && types.length > 0) {
            for (ComponentEntity ent : this.componentDao.getByType(types)) {
                result.add(this.toComm(ent, req));
            }
        } else {
            for (ComponentEntity ent : this.componentDao.getAll()) {
                result.add(this.toComm(ent, req));
            }
        }
        return result;
    }

    protected ComponentEntity toEntity(Component commObj) {
        ComponentEntity entity = new ComponentEntity();
        entity.setId(commObj.getId());
        entity.setName(commObj.getName());
        entity.setDisplayName(commObj.getDisplayName());
        entity.setDescription(commObj.getDescription());
        entity.setUrl(commObj.getUrl());
        entity.setType((ComponentTypeEntity)this.componentTypeDao.retrieve((Object)commObj.getId()));
        return entity;
    }

    protected boolean isAuthorizedComm(Component commObj, HttpServletRequest req) {
        return true;
    }

    protected Component toComm(ComponentEntity entity, HttpServletRequest req) {
        Component comm = new Component();
        comm.setId(entity.getId());
        comm.setName(entity.getName());
        comm.setDisplayName(entity.getDisplayName());
        comm.setDescription(entity.getDescription());
        comm.setUrl(entity.getUrl());
        comm.setType(entity.getType().getId());
        return comm;
    }

    protected boolean isAuthorizedEntity(ComponentEntity entity, HttpServletRequest req) {
        return true;
    }
}

