/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.registry.service.resource;

import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.eurekaclinical.common.resource.AbstractGroupResource;
import org.eurekaclinical.registry.client.comm.RegistryGroup;
import org.eurekaclinical.registry.service.dao.ComponentDao;
import org.eurekaclinical.registry.service.entity.ComponentEntity;
import org.eurekaclinical.registry.service.entity.GroupEntity;
import org.eurekaclinical.standardapis.dao.GroupDao;
import org.eurekaclinical.standardapis.exception.HttpStatusException;

@Path(value="/protected/groups")
@Transactional
public class GroupResource
extends AbstractGroupResource<GroupEntity, RegistryGroup> {
    private final ComponentDao<ComponentEntity> componentDao;

    @Inject
    public GroupResource(GroupDao<GroupEntity> inGroupDao, ComponentDao<ComponentEntity> componentDao) {
        super(inGroupDao);
        this.componentDao = componentDao;
    }

    protected RegistryGroup toComm(GroupEntity groupEntity, HttpServletRequest req) {
        RegistryGroup group = new RegistryGroup();
        group.setId(groupEntity.getId());
        group.setName(groupEntity.getName());
        ArrayList<Long> components = new ArrayList<Long>();
        for (ComponentEntity component : groupEntity.getComponents()) {
            components.add(component.getId());
        }
        group.setComponents(components);
        return group;
    }

    protected GroupEntity toEntity(RegistryGroup commObj) {
        GroupEntity entity = new GroupEntity();
        entity.setId(commObj.getId());
        entity.setName(commObj.getName());
        for (Long componentsID : commObj.getComponents()) {
            ComponentEntity componentEntity = (ComponentEntity)this.componentDao.retrieve((Object)componentsID);
            if (componentEntity != null) {
                entity.addComponents(componentEntity);
                continue;
            }
            throw new HttpStatusException(Response.Status.BAD_REQUEST);
        }
        return entity;
    }

    protected boolean isAuthorizedComm(RegistryGroup commObj, HttpServletRequest req) {
        return true;
    }

    protected boolean isAuthorizedEntity(GroupEntity entity, HttpServletRequest req) {
        return true;
    }
}

