/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.registry.service.resource;

import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.resource.AbstractUserResource;
import org.eurekaclinical.registry.service.dao.RegistryServiceRoleDao;
import org.eurekaclinical.registry.service.entity.AuthorizedRoleEntity;
import org.eurekaclinical.registry.service.entity.AuthorizedUserEntity;
import org.eurekaclinical.standardapis.dao.UserDao;

@Path(value="/protected/users")
@Transactional
public class UserResource
extends AbstractUserResource<User, AuthorizedUserEntity, AuthorizedRoleEntity> {
    private final RegistryServiceRoleDao roleDao;

    @Inject
    public UserResource(UserDao<AuthorizedUserEntity> inUserDao, RegistryServiceRoleDao inRoleDao) {
        super(inUserDao);
        this.roleDao = inRoleDao;
    }

    protected User toComm(AuthorizedUserEntity userEntity, HttpServletRequest req) {
        User user = new User();
        user.setId(userEntity.getId());
        user.setUsername(userEntity.getUsername());
        ArrayList<Long> roles = new ArrayList<Long>();
        for (AuthorizedRoleEntity roleEntity : userEntity.getRoles()) {
            roles.add(roleEntity.getId());
        }
        user.setRoles(roles);
        return user;
    }

    protected AuthorizedUserEntity toEntity(User user) {
        List roleEntities = this.roleDao.getAll();
        AuthorizedUserEntity userEntity = new AuthorizedUserEntity();
        userEntity.setId(user.getId());
        userEntity.setUsername(user.getUsername());
        ArrayList<AuthorizedRoleEntity> userRoleEntities = new ArrayList<AuthorizedRoleEntity>();
        for (Long roleId : user.getRoles()) {
            for (AuthorizedRoleEntity roleEntity : roleEntities) {
                if (!roleEntity.getId().equals(roleId)) continue;
                userRoleEntities.add(roleEntity);
            }
        }
        userEntity.setRoles(userRoleEntities);
        return userEntity;
    }
}

