/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.props;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EurekaClinicalProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaClinicalProperties.class);
    private static final String CONFIG_DIR_SYS_PROP = "eureka.config.dir";
    private static final String PROPERTIES_FILENAME = "application.properties";
    private static final String FALLBACK_CONFIG_FILE = "/application.properties";
    private final Properties properties;
    private String configDir;

    protected EurekaClinicalProperties(String defaultConfigDir) {
        if (defaultConfigDir == null) {
            throw new IllegalArgumentException("defaultConfigDir cannot be null");
        }
        this.properties = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream(FALLBACK_CONFIG_FILE);){
            if (inputStream != null) {
                this.properties.load(inputStream);
            }
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)("Fallback configuration is unavailable: " + ioe.getMessage()));
        }
        this.configDir = System.getProperty(CONFIG_DIR_SYS_PROP);
        if (this.configDir == null) {
            this.configDir = defaultConfigDir;
        }
        if (this.configDir == null) {
            throw new AssertionError((Object)"eureka.config.dir not specified in /application.properties");
        }
        this.properties.remove(CONFIG_DIR_SYS_PROP);
        File configFile = new File(this.configDir, PROPERTIES_FILENAME);
        if (configFile.exists()) {
            LOGGER.info("Trying to load default configuration from {}", (Object)configFile.getAbsolutePath());
            try (FileInputStream inputStream = new FileInputStream(configFile);){
                this.properties.load(inputStream);
            }
            catch (IOException ex) {
                LOGGER.error("Error reading application.properties file {}: {}. Built-in defaults will be used, some of which are unlikely to be what you want.", (Object)configFile.getAbsolutePath(), (Object)ex.getMessage());
            }
        } else {
            LOGGER.warn("No configuration file found at {}. Built-in defaults will be used, some of which are unlikely to be what you want.", (Object)configFile.getAbsolutePath());
        }
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public String getStage() {
        return this.getValue("eurekaclinical.stage", "DEVELOPMENT");
    }

    public abstract String getUrl();

    protected final String getValue(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    protected final String getValue(String propertyName, String defaultValue) {
        String value = this.getValue(propertyName);
        if (value == null) {
            if (defaultValue == null) {
                LOGGER.warn("Property '{}' is not specified in " + this.getClass().getName() + ", and no default is specified.", (Object)propertyName);
            }
            value = defaultValue;
        }
        return value;
    }

    protected final List<String> getStringListValue(String inPropertyName) {
        ArrayList<String> result = null;
        String value = this.properties.getProperty(inPropertyName);
        if (value != null) {
            String[] temp = value.split("\\s+");
            result = new ArrayList<String>(temp.length);
            for (String s : temp) {
                String trimmed = s.trim();
                if (trimmed.length() <= 0) continue;
                result.add(s.trim());
            }
        }
        return result;
    }

    protected final List<String> getStringListValue(String inPropertyName, List<String> defaultValue) {
        List<String> result = this.getStringListValue(inPropertyName);
        if (result == null) {
            LOGGER.warn("Property not found in configuration: {}", (Object)inPropertyName);
            result = defaultValue;
        }
        return result;
    }

    protected final int getIntValue(String propertyName, int defaultValue) {
        int result;
        String property = this.properties.getProperty(propertyName);
        try {
            result = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid integer property in configuration: {}", (Object)propertyName);
            result = defaultValue;
        }
        return result;
    }
}

