/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.dao;

import java.util.List;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import org.eurekaclinical.standardapis.dao.Dao;
import org.eurekaclinical.standardapis.dao.DatabaseSupport;
import org.eurekaclinical.standardapis.dao.QueryPathProvider;

public class GenericDao<T, PK>
implements Dao<T, PK> {
    private final Class<T> entityClass;
    private final Provider<EntityManager> managerProvider;

    protected GenericDao(Class<T> inEntityClass, Provider<EntityManager> inManagerProvider) {
        this.entityClass = inEntityClass;
        this.managerProvider = inManagerProvider;
    }

    @Override
    public final T create(T entity) {
        EntityManager entityManager = this.getEntityManager();
        entityManager.persist(entity);
        return entity;
    }

    @Override
    public final T retrieve(PK uniqueId) {
        return (T)this.getEntityManager().find(this.entityClass, uniqueId);
    }

    @Override
    public final T update(T entity) {
        EntityManager entityManager = this.getEntityManager();
        Object result = entityManager.merge(entity);
        return (T)result;
    }

    @Override
    public final T remove(T entity) {
        EntityManager entityManager = this.getEntityManager();
        if (entityManager.contains(entity)) {
            entityManager.remove(entity);
        } else {
            entityManager.remove(entityManager.merge(entity));
        }
        return entity;
    }

    @Override
    public final T refresh(T entity) {
        this.getEntityManager().refresh(entity);
        return entity;
    }

    @Override
    public final List<T> getAll() {
        DatabaseSupport dbSupport = new DatabaseSupport(this.getEntityManager());
        return dbSupport.getAll(this.entityClass);
    }

    protected final List<T> getListAsc(SingularAttribute<T, ?> attribute) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        criteriaQuery.orderBy(new Order[]{builder.asc((Expression)root.get(attribute))});
        return entityManager.createQuery(criteriaQuery).getResultList();
    }

    protected final <Y> T getUniqueByAttribute(SingularAttribute<T, Y> attribute, Y value) {
        try {
            return new DatabaseSupport(this.getEntityManager()).getUniqueByAttribute(this.entityClass, attribute, value);
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    protected final <Y> T getUniqueByAttribute(String attributeName, Y value) {
        try {
            return new DatabaseSupport(this.getEntityManager()).getUniqueByAttribute(this.entityClass, attributeName, value);
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    protected final <Y> List<T> getListByAttribute(SingularAttribute<T, Y> attribute, Y value) {
        return new DatabaseSupport(this.getEntityManager()).getListByAttribute(this.entityClass, attribute, value);
    }

    protected final <Y> List<T> getListByAttribute(QueryPathProvider<T, Y> provider, Y value) {
        return new DatabaseSupport(this.getEntityManager()).getListByAttribute(this.entityClass, provider, value);
    }

    protected final <Y> List<T> getListByAttributeIn(SingularAttribute<T, Y> attribute, List<Y> values) {
        return new DatabaseSupport(this.getEntityManager()).getListByAttributeIn(this.entityClass, attribute, values);
    }

    protected final <Y> List<T> getListByAttributeIn(QueryPathProvider<T, Y> provider, List<Y> values) {
        return new DatabaseSupport(this.getEntityManager()).getListByAttributeIn(this.entityClass, provider, values);
    }

    protected final EntityManager getEntityManager() {
        return (EntityManager)this.managerProvider.get();
    }
}

