/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.filter;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RolesRequestWrapper
extends HttpServletRequestWrapper {
    private final Principal principal;
    private final Set<String> roles;
    private final HttpServletRequest request;

    public RolesRequestWrapper(HttpServletRequest inRequest, Principal inPrincipal, String[] inRoles) {
        super(inRequest);
        this.request = inRequest;
        this.principal = inPrincipal;
        this.roles = new HashSet<String>();
        for (String role : inRoles) {
            this.roles.add(role);
        }
    }

    public boolean isUserInRole(String inRole) {
        boolean result = this.roles == null ? this.request.isUserInRole(inRole) : this.roles.contains(inRole);
        return result;
    }

    public Principal getUserPrincipal() {
        Principal result = this.principal == null ? this.request.getUserPrincipal() : this.principal;
        return result;
    }

    public Set<String> getRoles() {
        return this.roles;
    }
}

