/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.filter;

import java.security.Principal;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.standardapis.entity.RoleEntity;
import org.eurekaclinical.standardapis.entity.UserEntity;
import org.eurekaclinical.standardapis.filter.AbstractRolesFilter;

@Singleton
public class RolesFromDbFilter
extends AbstractRolesFilter {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final UserDao<? extends UserEntity<? extends RoleEntity>> userDao;

    @Inject
    public RolesFromDbFilter(UserDao<? extends UserEntity<? extends RoleEntity>> inUserDao) {
        this.userDao = inUserDao;
    }

    @Override
    protected String[] getRoles(Principal principal) {
        UserEntity<? extends RoleEntity> user = this.userDao.getByPrincipal(principal);
        if (user != null) {
            List<? extends RoleEntity> roles = user.getRoles();
            String[] roleNames = new String[roles.size()];
            int i = 0;
            for (RoleEntity roleEntity : roles) {
                roleNames[i++] = roleEntity.getName();
            }
            return roleNames;
        }
        return EMPTY_STRING_ARRAY;
    }
}

