/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.dao;

import java.util.List;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import org.eurekaclinical.standardapis.dao.QueryPathProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseSupport {
    private static Logger LOGGER = LoggerFactory.getLogger(DatabaseSupport.class);
    private final Provider<EntityManager> entityManagerProvider;

    public DatabaseSupport(EntityManager entityManager) {
        if (entityManager == null) {
            throw new IllegalArgumentException("entityManager cannot be null");
        }
        this.entityManagerProvider = new EntityManagerProvider(entityManager);
    }

    public DatabaseSupport(Provider<EntityManager> entityManagerProvider) {
        if (entityManagerProvider == null) {
            throw new IllegalArgumentException("entityManagerProvider cannot be null");
        }
        this.entityManagerProvider = entityManagerProvider;
    }

    public <T> List<T> getAll(Class<T> entityCls) {
        if (entityCls == null) {
            throw new IllegalArgumentException("entityCls cannot be null");
        }
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entityCls);
        criteriaQuery.from(entityCls);
        TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
        List jobs = typedQuery.getResultList();
        return jobs;
    }

    public <T, Y> T getUniqueByAttribute(Class<T> entityCls, SingularAttribute<T, Y> attribute, Y value) {
        if (entityCls == null) {
            throw new IllegalArgumentException("entityCls cannot be null");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("attribute cannot be null");
        }
        TypedQuery<T> query = this.createTypedQuery(entityCls, attribute, value);
        Object result = null;
        try {
            result = query.getSingleResult();
        }
        catch (NonUniqueResultException nure) {
            LOGGER.warn("Result not unique for {}: {} = {}", new Object[]{entityCls.getName(), attribute.getName(), value});
            result = query.getResultList().get(0);
        }
        catch (NoResultException nre) {
            LOGGER.debug("Result not existant for {}: {} = {}", new Object[]{entityCls.getName(), attribute.getName(), value});
        }
        return (T)result;
    }

    public <T, Y> T getUniqueByAttribute(Class<T> entityCls, String attributeName, Y value) {
        if (entityCls == null) {
            throw new IllegalArgumentException("entityCls cannot be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName cannot be null");
        }
        TypedQuery<T> query = this.createTypedQuery(entityCls, attributeName, value);
        Object result = null;
        try {
            result = query.getSingleResult();
        }
        catch (NonUniqueResultException nure) {
            LOGGER.warn("Result not unique for {}: {} = {}", new Object[]{entityCls.getName(), attributeName, value});
            result = query.getResultList().get(0);
        }
        catch (NoResultException nre) {
            LOGGER.debug("Result not existant for {}: {} = {}", new Object[]{entityCls.getName(), attributeName, value});
        }
        return (T)result;
    }

    public <T, Y> List<T> getListByAttribute(Class<T> entityCls, SingularAttribute<T, Y> attribute, Y value) {
        if (entityCls == null) {
            throw new IllegalArgumentException("entityCls cannot be null");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("attribute cannot be null");
        }
        TypedQuery<T> query = this.createTypedQuery(entityCls, attribute, value);
        return query.getResultList();
    }

    public <T, Y extends Number> List<T> getListByAttribute(Class<T> entityCls, SingularAttribute<T, Y> attribute, SqlComparator comparator, Y value) {
        if (entityCls == null) {
            throw new IllegalArgumentException("entityCls cannot be null");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("attribute cannot be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator cannot be null");
        }
        TypedQuery<T> query = this.createTypedQuery(entityCls, attribute, comparator, value);
        return query.getResultList();
    }

    public <T, Y> List<T> getListByAttributeIn(Class<T> entityCls, SingularAttribute<T, Y> attribute, List<Y> values) {
        if (entityCls == null) {
            throw new IllegalArgumentException("entityCls cannot be null");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("attribute cannot be null");
        }
        TypedQuery<T> query = this.createTypedQueryIn(entityCls, attribute, values);
        return query.getResultList();
    }

    public <T, Y> List<T> getListByAttribute(Class<T> entityCls, QueryPathProvider<T, Y> provider, Y value) {
        if (entityCls == null) {
            throw new IllegalArgumentException("entityCls cannot be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        TypedQuery<T> typedQuery = this.createTypedQuery(entityCls, provider, value);
        return typedQuery.getResultList();
    }

    public <T, Y> List<T> getListByAttributeIn(Class<T> entityCls, QueryPathProvider<T, Y> provider, List<Y> values) {
        if (entityCls == null) {
            throw new IllegalArgumentException("entityCls cannot be null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        TypedQuery<T> typedQuery = this.createTypedQueryIn(entityCls, provider, values);
        return typedQuery.getResultList();
    }

    private <T, Y> TypedQuery<T> createTypedQueryIn(Class<T> entityCls, QueryPathProvider<T, Y> provider, List<Y> values) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entityCls);
        Root root = criteriaQuery.from(entityCls);
        Path<Y> path = provider.getPath(root, builder);
        CriteriaBuilder.In in = builder.in(path);
        if (values != null) {
            for (Y val : values) {
                in.value(val);
            }
        }
        return entityManager.createQuery(criteriaQuery.where((Expression)in));
    }

    private <T, Y> TypedQuery<T> createTypedQuery(Class<T> entityCls, QueryPathProvider<T, Y> provider, Y value) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entityCls);
        Root root = criteriaQuery.from(entityCls);
        Path<Y> path = provider.getPath(root, builder);
        return entityManager.createQuery(criteriaQuery.where((Expression)builder.equal(path, value)));
    }

    private <T, Y> TypedQuery<T> createTypedQueryIn(Class<T> entityCls, SingularAttribute<T, Y> attribute, List<Y> values) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entityCls);
        Root root = criteriaQuery.from(entityCls);
        Path path = root.get(attribute);
        CriteriaBuilder.In in = builder.in((Expression)path);
        if (values != null) {
            for (Y val : values) {
                in.value(val);
            }
        }
        return entityManager.createQuery(criteriaQuery.where((Expression)in));
    }

    private <T, Y> TypedQuery<T> createTypedQuery(Class<T> entityCls, SingularAttribute<T, Y> attribute, Y value) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entityCls);
        Root root = criteriaQuery.from(entityCls);
        Path path = root.get(attribute);
        return entityManager.createQuery(criteriaQuery.where((Expression)builder.equal((Expression)path, value)));
    }

    private <T, Y> TypedQuery<T> createTypedQuery(Class<T> entityCls, String attributeName, Y value) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entityCls);
        Root root = criteriaQuery.from(entityCls);
        Path path = root.get(attributeName);
        return entityManager.createQuery(criteriaQuery.where((Expression)builder.equal((Expression)path, value)));
    }

    private <T, Y extends Number> TypedQuery<T> createTypedQuery(Class<T> entityCls, SingularAttribute<T, Y> attribute, SqlComparator comparator, Y value) {
        Predicate pred;
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entityCls);
        Root root = criteriaQuery.from(entityCls);
        Path path = root.get(attribute);
        switch (comparator) {
            case LESS_THAN: {
                pred = builder.lt((Expression)path, value);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                pred = builder.le((Expression)path, value);
                break;
            }
            case EQUAL_TO: {
                pred = builder.equal((Expression)path, value);
                break;
            }
            case NOT_EQUAL_TO: {
                pred = builder.notEqual((Expression)path, value);
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                pred = builder.ge((Expression)path, value);
                break;
            }
            case GREATER_THAN: {
                pred = builder.gt((Expression)path, value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid SQLComparator: " + (Object)((Object)comparator)));
            }
        }
        return entityManager.createQuery(criteriaQuery.where((Expression)pred));
    }

    private static class EntityManagerProvider
    implements Provider<EntityManager> {
        private final EntityManager entityManager;

        EntityManagerProvider(EntityManager inEntityManager) {
            assert (inEntityManager != null) : "inEntityManager cannot be null";
            this.entityManager = inEntityManager;
        }

        public EntityManager get() {
            return this.entityManager;
        }
    }

    public static enum SqlComparator {
        LESS_THAN_OR_EQUAL_TO,
        LESS_THAN,
        EQUAL_TO,
        NOT_EQUAL_TO,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL_TO;

    }
}

