/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.filter;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eurekaclinical.standardapis.filter.RolesFilter;
import org.eurekaclinical.standardapis.filter.RolesRequestWrapper;

public abstract class AbstractRolesFilter
implements RolesFilter {
    public void init(FilterConfig fc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest inRequest, ServletResponse inResponse, FilterChain inChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)inRequest;
        Principal principal = servletRequest.getUserPrincipal();
        HttpSession session = servletRequest.getSession(false);
        if (principal != null && session != null) {
            String[] roleNames;
            HttpSession httpSession = session;
            synchronized (httpSession) {
                roleNames = (String[])session.getAttribute("roles");
                if (roleNames == null) {
                    roleNames = this.getRoles(principal, inRequest);
                    session.setAttribute("roles", (Object)roleNames);
                }
            }
            RolesRequestWrapper wrappedRequest = new RolesRequestWrapper(servletRequest, principal, roleNames);
            inChain.doFilter((ServletRequest)wrappedRequest, inResponse);
        } else {
            inChain.doFilter(inRequest, inResponse);
        }
    }

    protected abstract String[] getRoles(Principal var1, ServletRequest var2) throws ServletException;

    public void destroy() {
    }
}

