/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.exception;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class HttpStatusException
extends WebApplicationException {
    private static final long serialVersionUID = 1L;
    private final Response.Status status;

    public HttpStatusException(Response.Status status) {
        super(HttpStatusException.buildResponse(status));
        this.status = status;
    }

    public HttpStatusException(Response.Status status, String message) {
        super(HttpStatusException.buildResponse(status, message));
        this.status = status;
    }

    public HttpStatusException(Response.Status status, Throwable cause) {
        super(cause, HttpStatusException.buildResponse(status, cause));
        this.status = status;
    }

    public HttpStatusException(Response.Status status, String message, Throwable cause) {
        super(cause, message != null ? HttpStatusException.buildResponse(status, message) : HttpStatusException.buildResponse(status, cause));
        this.status = status;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    private static Response buildResponse(Response.Status status, Throwable cause) {
        if (cause != null) {
            return Response.status((Response.Status)status).entity((Object)cause.getMessage()).type("text/plain").build();
        }
        return HttpStatusException.buildResponse(status);
    }

    private static Response buildResponse(Response.Status status, String message) {
        if (message != null) {
            return Response.status((Response.Status)status).entity((Object)message).type("text/plain").build();
        }
        return HttpStatusException.buildResponse(status);
    }

    private static Response buildResponse(Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)status.getReasonPhrase()).type("text/plain").build();
    }
}

