/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.dao;

import java.security.Principal;
import java.util.List;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import org.eurekaclinical.standardapis.dao.GenericDao;
import org.eurekaclinical.standardapis.dao.RoleDao;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.standardapis.entity.RoleEntity;
import org.eurekaclinical.standardapis.entity.UserEntity;

public abstract class AbstractJpaUserDao<R extends RoleEntity, U extends UserEntity<R>>
extends GenericDao<U, Long>
implements UserDao<U> {
    private final RoleDao<R> roleDao;

    public AbstractJpaUserDao(Class<U> cls, Provider<EntityManager> inEMProvider, RoleDao<R> inRoleDao) {
        super(cls, inEMProvider);
        this.roleDao = inRoleDao;
    }

    @Override
    public U getByHttpServletRequest(HttpServletRequest request) {
        return this.getByPrincipal(request.getUserPrincipal());
    }

    @Override
    public U getByPrincipal(Principal principal) {
        return (U)this.getByName(principal.getName());
    }

    @Override
    public U getByName(String username) {
        return (U)((UserEntity)this.getUniqueByAttribute("username", username));
    }

    @Override
    public void createUser(String username, List<String> roles) {
        Object user = this.newUser();
        user.setUsername(username);
        for (String roleName : roles) {
            RoleEntity byName = (RoleEntity)this.roleDao.getByName(roleName);
            user.addRole((RoleEntity)byName);
        }
        this.create(user);
    }
}

