/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.filter;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RolesRequestWrapper
extends HttpServletRequestWrapper {
    private final Principal principal;
    private final Set<String> roles;
    private final HttpServletRequest request;

    public RolesRequestWrapper(HttpServletRequest inRequest, Principal inPrincipal, String[] inRoles) {
        super(inRequest);
        this.request = inRequest;
        this.principal = inPrincipal;
        if (inRoles != null) {
            this.roles = new HashSet<String>();
            for (String role : inRoles) {
                this.roles.add(role);
            }
        } else {
            this.roles = null;
        }
    }

    public boolean isUserInRole(String inRole) {
        if (this.roles == null) {
            return this.request.isUserInRole(inRole);
        }
        return this.roles.contains(inRole);
    }

    public Principal getUserPrincipal() {
        if (this.principal == null) {
            return this.request.getUserPrincipal();
        }
        return this.principal;
    }

    public Set<String> getRoles() {
        return this.roles;
    }
}

