/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.dao;

import java.util.List;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import org.eurekaclinical.standardapis.dao.Dao;
import org.eurekaclinical.standardapis.dao.DatabaseSupport;
import org.eurekaclinical.standardapis.dao.QueryPathProvider;

public class GenericDao<T, PK>
implements Dao<T, PK> {
    final Class<T> entityClass;
    private final Provider<EntityManager> managerProvider;
    private final DatabaseSupport databaseSupport;

    protected GenericDao(Class<T> inEntityClass, Provider<EntityManager> inManagerProvider) {
        this.entityClass = inEntityClass;
        this.managerProvider = inManagerProvider;
        this.databaseSupport = new DatabaseSupport(this.managerProvider);
    }

    @Override
    public T create(T entity) {
        EntityManager entityManager = this.getEntityManager();
        entityManager.persist(entity);
        return entity;
    }

    @Override
    public final T retrieve(PK uniqueId) {
        return (T)this.getEntityManager().find(this.getEntityClass(), uniqueId);
    }

    @Override
    public T update(T entity) {
        EntityManager entityManager = this.getEntityManager();
        Object result = entityManager.merge(entity);
        return (T)result;
    }

    @Override
    public T remove(T entity) {
        EntityManager entityManager = this.getEntityManager();
        if (entityManager.contains(entity)) {
            entityManager.remove(entity);
        } else {
            entityManager.remove(entityManager.merge(entity));
        }
        return entity;
    }

    @Override
    public T refresh(T entity) {
        this.getEntityManager().refresh(entity);
        return entity;
    }

    @Override
    public List<T> getAll() {
        return this.getDatabaseSupport().getAll(this.getEntityClass());
    }

    @Override
    public List<T> getAll(int firstResult, int maxResults) {
        return this.getDatabaseSupport().getAll(this.getEntityClass(), firstResult, maxResults);
    }

    protected List<T> getListAsc(SingularAttribute<T, ?> attribute) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.getEntityClass());
        Root root = criteriaQuery.from(this.getEntityClass());
        criteriaQuery.orderBy(new Order[]{builder.asc((Expression)root.get(attribute))});
        return entityManager.createQuery(criteriaQuery).getResultList();
    }

    protected List<T> getListAsc(SingularAttribute<T, ?> attribute, int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.getEntityClass());
        Root root = criteriaQuery.from(this.getEntityClass());
        criteriaQuery.orderBy(new Order[]{builder.asc((Expression)root.get(attribute))});
        return entityManager.createQuery(criteriaQuery).setFirstResult(firstResult).setMaxResults(maxResults).getResultList();
    }

    protected <Y> T getUniqueByAttribute(SingularAttribute<T, Y> attribute, Y value) {
        try {
            return this.getDatabaseSupport().getUniqueByAttribute(this.getEntityClass(), attribute, value);
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    protected <Y> T getUniqueByAttribute(String attributeName, Y value) {
        try {
            return this.getDatabaseSupport().getUniqueByAttribute(this.getEntityClass(), attributeName, value);
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    protected <Y> List<T> getListByAttribute(SingularAttribute<T, Y> attribute, Y value) {
        return this.getDatabaseSupport().getListByAttribute(this.getEntityClass(), attribute, value);
    }

    protected <Y> List<T> getListByAttribute(QueryPathProvider<T, Y> provider, Y value) {
        return this.getDatabaseSupport().getListByAttribute(this.getEntityClass(), provider, value);
    }

    protected <Y> List<T> getListByAttributeIn(SingularAttribute<T, Y> attribute, List<Y> values) {
        return this.getDatabaseSupport().getListByAttributeIn(this.getEntityClass(), attribute, values);
    }

    protected <Y> List<T> getListByAttributeIn(QueryPathProvider<T, Y> provider, List<Y> values) {
        return this.getDatabaseSupport().getListByAttributeIn(this.getEntityClass(), provider, values);
    }

    protected EntityManager getEntityManager() {
        return (EntityManager)this.managerProvider.get();
    }

    protected DatabaseSupport getDatabaseSupport() {
        return this.databaseSupport;
    }

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }
}

