/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.service.dao;

import java.text.MessageFormat;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.eurekaclinical.standardapis.dao.GenericDao;
import org.eurekaclinical.useragreement.service.dao.UserAgreementStatusDao;
import org.eurekaclinical.useragreement.service.entity.UserAgreementStatusEntity;
import org.eurekaclinical.useragreement.service.entity.UserAgreementStatusEntity_;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaUserAgreementStatusDao
extends GenericDao<UserAgreementStatusEntity, Long>
implements UserAgreementStatusDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaUserAgreementStatusDao.class);

    @Inject
    public JpaUserAgreementStatusDao(Provider<EntityManager> inEMProvider) {
        super(UserAgreementStatusEntity.class, inEMProvider);
    }

    public UserAgreementStatusEntity getByUsername(String username) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(UserAgreementStatusEntity.class);
        Root root = criteriaQuery.from(UserAgreementStatusEntity.class);
        Path usernamePath = root.get(UserAgreementStatusEntity_.username);
        TypedQuery query = entityManager.createQuery(criteriaQuery.where((Expression)builder.equal((Expression)usernamePath, (Object)username)));
        UserAgreementStatusEntity result = null;
        try {
            result = (UserAgreementStatusEntity)query.getSingleResult();
        }
        catch (NonUniqueResultException nure) {
            String msg = MessageFormat.format("More than one user with {0} = {1}", UserAgreementStatusEntity_.username, username);
            LOGGER.error(msg);
            throw new AssertionError((Object)msg);
        }
        catch (NoResultException nre) {
            LOGGER.debug("No user with {} = {} and {} = {}", (Object)UserAgreementStatusEntity_.username, (Object)username);
        }
        return result;
    }
}

