/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.service.dao;

import java.util.Date;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.eurekaclinical.standardapis.dao.GenericDao;
import org.eurekaclinical.useragreement.service.dao.UserAgreementDao;
import org.eurekaclinical.useragreement.service.entity.UserAgreementEntity;
import org.eurekaclinical.useragreement.service.entity.UserAgreementEntity_;

public class JpaUserAgreementDao
extends GenericDao<UserAgreementEntity, Long>
implements UserAgreementDao {
    @Inject
    public JpaUserAgreementDao(Provider<EntityManager> inEMProvider) {
        super(UserAgreementEntity.class, inEMProvider);
    }

    public UserAgreementEntity getCurrent() {
        UserAgreementEntity result;
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(UserAgreementEntity.class);
        Root root = criteriaQuery.from(UserAgreementEntity.class);
        criteriaQuery.where((Expression)builder.or((Expression)builder.isNull((Expression)root.get(UserAgreementEntity_.expiredAt)), (Expression)builder.greaterThanOrEqualTo((Expression)root.get(UserAgreementEntity_.expiredAt), (Comparable)new Date())));
        try {
            result = (UserAgreementEntity)entityManager.createQuery(criteriaQuery).getSingleResult();
        }
        catch (NoResultException ex) {
            result = null;
        }
        return result;
    }

    public UserAgreementEntity createOrUpdate(String inText) {
        if (inText == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        UserAgreementEntity current = this.getCurrent();
        Date now = new Date();
        if (current != null) {
            current.setExpiredAt(now);
        }
        UserAgreementEntity result = new UserAgreementEntity();
        result.setText(inText);
        result.setEffectiveAt(now);
        return (UserAgreementEntity)this.create((Object)result);
    }
}

