/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.service.resource;

import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import org.eurekaclinical.common.comm.User;
import org.eurekaclinical.common.resource.AbstractUserResource;
import org.eurekaclinical.standardapis.dao.RoleDao;
import org.eurekaclinical.standardapis.dao.UserDao;
import org.eurekaclinical.useragreement.service.entity.RoleEntity;
import org.eurekaclinical.useragreement.service.entity.UserEntity;

@Path(value="/protected/users")
@Transactional
public class UserResource
extends AbstractUserResource<User, UserEntity, RoleEntity> {
    private final RoleDao<RoleEntity> roleDao;

    @Inject
    public UserResource(UserDao<UserEntity> inUserDao, RoleDao<RoleEntity> inRoleDao) {
        super(inUserDao);
        this.roleDao = inRoleDao;
    }

    protected User toComm(UserEntity userEntity, HttpServletRequest req) {
        User user = new User();
        user.setId(userEntity.getId());
        user.setUsername(userEntity.getUsername());
        ArrayList<Long> roles = new ArrayList<Long>();
        for (RoleEntity roleEntity : userEntity.getRoles()) {
            roles.add(roleEntity.getId());
        }
        user.setRoles(roles);
        return user;
    }

    protected UserEntity toEntity(User user) {
        List roleEntities = this.roleDao.getAll();
        UserEntity userEntity = new UserEntity();
        userEntity.setId(user.getId());
        userEntity.setUsername(user.getUsername());
        ArrayList<RoleEntity> userRoleEntities = new ArrayList<RoleEntity>();
        for (Long roleId : user.getRoles()) {
            for (RoleEntity roleEntity : roleEntities) {
                if (!roleEntity.getId().equals(roleId)) continue;
                userRoleEntities.add(roleEntity);
            }
        }
        userEntity.setRoles(userRoleEntities);
        return userEntity;
    }
}

