/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.service.entity;

import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.eurekaclinical.useragreement.client.comm.UserAgreement;

@Entity
@Table(name="user_agreements")
public class UserAgreementEntity {
    @Id
    @SequenceGenerator(name="USER_AGR_SEQ_GENERATOR", sequenceName="USER_AGR_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_AGR_SEQ_GENERATOR")
    private Long id;
    @Lob
    @Column(nullable=false)
    private String text;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date effectiveAt;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date expiredAt;

    public Long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getEffectiveAt() {
        return this.effectiveAt;
    }

    public void setEffectiveAt(Date effectiveAt) {
        this.effectiveAt = effectiveAt;
    }

    public Date getExpiredAt() {
        return this.expiredAt;
    }

    public void setExpiredAt(Date expiredAt) {
        this.expiredAt = expiredAt;
    }

    public UserAgreement toUserAgreement() {
        UserAgreement result = new UserAgreement();
        result.setText(this.text);
        result.setId(this.id);
        result.setEffectiveAt(this.effectiveAt);
        result.setExpiredAt(this.expiredAt);
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAgreementEntity other = (UserAgreementEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "UserAgreementEntity{id=" + this.id + ", text=" + this.text + ", effectiveAt=" + this.effectiveAt + ", expiredAt=" + this.expiredAt + '}';
    }
}

