/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.webapp.servlet;

import com.google.inject.Injector;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.useragreement.client.EurekaClinicalUserAgreementClient;
import org.eurekaclinical.useragreement.client.comm.UserAgreementStatus;

@Singleton
public class AgreeServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Inject
    private Injector injector;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Long userAgreementId;
        String service = req.getParameter("service");
        String fullname = req.getParameter("fullname");
        if (fullname == null) {
            throw new ServletException("fullname must be specified");
        }
        String userAgreementIdStr = req.getParameter("useragreementid");
        if (userAgreementIdStr == null) {
            throw new ServletException("The user agreement id must be specified");
        }
        try {
            userAgreementId = Long.valueOf(userAgreementIdStr);
        }
        catch (NumberFormatException ex) {
            throw new ServletException("The user agreement id must be a long");
        }
        UserAgreementStatus status = new UserAgreementStatus();
        status.setUsername(req.getRemoteUser());
        status.setFullname(fullname);
        status.setUserAgreement(userAgreementId);
        try {
            EurekaClinicalUserAgreementClient client = (EurekaClinicalUserAgreementClient)this.injector.getInstance(EurekaClinicalUserAgreementClient.class);
            client.submitUserAgreement(status);
        }
        catch (ClientException ex) {
            throw new ServletException("User agreement submission failed", (Throwable)ex);
        }
        if (service != null) {
            resp.sendRedirect(service);
        } else {
            req.getServletContext().getRequestDispatcher("/WEB-INF/saved.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }
}

