/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.useragreement.webapp.servlet;

import com.google.inject.Injector;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eurekaclinical.common.comm.clients.ClientException;
import org.eurekaclinical.useragreement.client.EurekaClinicalUserAgreementClient;
import org.eurekaclinical.useragreement.client.comm.Status;
import org.eurekaclinical.useragreement.client.comm.UserAgreementStatus;

@Singleton
public class PresentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Inject
    private Injector injector;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean foundAndActive;
        String service = req.getParameter("service");
        try {
            EurekaClinicalUserAgreementClient client = (EurekaClinicalUserAgreementClient)this.injector.getInstance(EurekaClinicalUserAgreementClient.class);
            UserAgreementStatus userAgreementStatus = client.getUserAgreementStatus();
            foundAndActive = userAgreementStatus.getStatus() == Status.ACTIVE;
        }
        catch (ClientException ex) {
            if (ex.getResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                foundAndActive = false;
            }
            throw new ServletException((Throwable)ex);
        }
        if (foundAndActive) {
            if (service != null) {
                resp.sendRedirect(service);
            } else {
                req.getServletContext().getRequestDispatcher("/WEB-INF/alreadyactive.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            }
        } else {
            req.getServletContext().getRequestDispatcher("/WEB-INF/present.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }
}

